/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Utils;

public abstract class BlockHPBase
extends Block {
    protected static boolean keepInventory = false;
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockHPBase(Material materialIn) {
        super(materialIn);
        this.func_149647_a(HorsePowerMod.creativeTab);
    }

    public abstract void emptiedOutput(World var1, BlockPos var2);

    public int getSlot(IBlockState state, float hitX, float hitY, float hitZ) {
        return -1;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        Object te;
        super.func_176208_a(worldIn, pos, state, player);
        if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K && (te = this.getTileEntity((IBlockAccess)worldIn, pos)) != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityHPBase)((Object)te)).getInventory());
            if (te instanceof TileEntityHPHorseBase && ((TileEntityHPHorseBase)((Object)te)).hasWorker()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)new ItemStack(Items.field_151058_ca));
            }
        }
    }

    @Nonnull
    public abstract Class<?> getTileClass();

    protected <T extends TileEntityHPBase> T getTileEntity(IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return (T)((Object)(tileentity != null && this.getTileClass().isAssignableFrom(tileentity.getClass()) ? (TileEntityHPBase)tileentity : null));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            return (TileEntity)this.getTileClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        this.func_176208_a(world, pos, state, player);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && !worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityHPBase) {
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntityHPBase te = (TileEntityHPBase)worldIn.func_175625_s(pos);
        TileEntityHPHorseBase teH = null;
        if (te == null) {
            return false;
        }
        if (te instanceof TileEntityHPHorseBase) {
            teH = (TileEntityHPHorseBase)te;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        EntityCreature creature = null;
        if (teH != null) {
            ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
            block0: for (Class<? extends EntityCreature> clazz : clazzes) {
                for (Object entity : worldIn.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                    EntityCreature tmp;
                    if (!(entity instanceof EntityCreature) || !(tmp = (EntityCreature)entity).func_110167_bD() || tmp.func_110166_bE() != playerIn) continue;
                    creature = tmp;
                    break block0;
                }
            }
        }
        if (teH != null && (stack.func_77973_b() instanceof ItemLead && creature != null || creature != null)) {
            if (!teH.hasWorker()) {
                creature.func_110160_i(true, false);
                teH.setWorker(creature);
                return true;
            }
            return false;
        }
        if (!stack.func_190926_b() && te.isItemValidForSlot(0, stack)) {
            ItemStack itemStack = te.getStackInSlot(0);
            boolean flag = false;
            if (itemStack.func_190926_b()) {
                te.setInventorySlotContents(0, stack.func_77946_l());
                stack.func_190920_e(stack.func_190916_E() - te.getInventoryStackLimit(stack));
                flag = true;
            } else if (TileEntityHPBase.canCombine(itemStack, stack)) {
                int i = stack.func_77976_d() - itemStack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemStack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                return true;
            }
        }
        int slot = this.getSlot(state.func_177230_c().getExtendedState(state, (IBlockAccess)worldIn, pos), hitX, hitY, hitZ);
        ItemStack result = ItemStack.field_190927_a;
        if (slot > -1) {
            result = te.removeStackFromSlot(slot);
        } else if (slot > -2 && (result = te.removeStackFromSlot(1)).func_190926_b() && (result = te.removeStackFromSlot(2)).func_190926_b() && stack.func_190926_b() && hand != EnumHand.OFF_HAND && !(result = te.removeStackFromSlot(0)).func_190926_b()) {
            this.emptiedOutput(worldIn, pos);
        }
        if (result.func_190926_b()) {
            if (!stack.func_190926_b()) {
                return false;
            }
            if (teH != null) {
                teH.setWorkerToPlayer(playerIn);
            }
        }
        if (!result.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)result, (int)EntityEquipmentSlot.MAINHAND.func_188452_c());
        }
        te.func_70296_d();
        return true;
    }
}

