/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.network.ClientMessageHandler;
import se.gory_moon.horsepower.recipes.HPRecipes;

public class SyncServerRecipesMessage
extends ClientMessageHandler<SyncServerRecipesMessage>
implements IMessage {
    private List<String> grindstoneRecipes = new ArrayList<String>();
    private List<String> handGrindstoneRecipes = new ArrayList<String>();
    private List<String> choppingRecipes = new ArrayList<String>();
    private List<String> manualChoppingRecipes = new ArrayList<String>();

    public SyncServerRecipesMessage() {
        this.grindstoneRecipes = Arrays.stream(Configs.recipes.grindstoneRecipes).collect(Collectors.toList());
        this.handGrindstoneRecipes = Arrays.stream(Configs.recipes.handGrindstoneRecipes).collect(Collectors.toList());
        this.choppingRecipes = Arrays.stream(Configs.recipes.choppingRecipes).collect(Collectors.toList());
        this.manualChoppingRecipes = Arrays.stream(Configs.recipes.manualChoppingRecipes).collect(Collectors.toList());
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.grindstoneRecipes.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.handGrindstoneRecipes.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.choppingRecipes.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.manualChoppingRecipes.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.grindstoneRecipes.size());
        this.grindstoneRecipes.forEach(s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        buf.writeInt(this.handGrindstoneRecipes.size());
        this.handGrindstoneRecipes.forEach(s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        buf.writeInt(this.choppingRecipes.size());
        this.choppingRecipes.forEach(s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        buf.writeInt(this.manualChoppingRecipes.size());
        this.manualChoppingRecipes.forEach(s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
    }

    @Override
    protected void handle(SyncServerRecipesMessage message, MessageContext ctx) {
        HPRecipes.serverSyncedRecipes = true;
        HPRecipes.instance().reloadRecipes(message.grindstoneRecipes, message.handGrindstoneRecipes, message.choppingRecipes, message.manualChoppingRecipes);
        HorsePowerMod.logger.info("Synced recipes from server");
    }
}

