/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.ChoppingRecipe;

public class ChoppingBlockCraftingWrapper
extends BlankRecipeWrapper
implements IShapedCraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ChoppingRecipe recipe;
    private final int width;
    private final int height;
    private final List<List<ItemStack>> outputs;

    public ChoppingBlockCraftingWrapper(ChoppingRecipe recipe) {
        this.recipe = recipe;
        for (Object input : this.recipe.getInput()) {
            ItemStack itemStack;
            if (!(input instanceof ItemStack) || (itemStack = (ItemStack)input).getCount() == 1) continue;
            itemStack.setCount(1);
        }
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : recipe.outputBlocks) {
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)recipe.getSimpleRecipeOutput().getItem());
            Block baseBlock = Block.getBlockFromItem((Item)stack.getItem());
            if (stack.getItemDamage() == Short.MAX_VALUE) {
                for (ItemStack sub : HorsePowerPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
                    builder.add((Object)BlockHPChoppingBase.createItemStack(block, baseBlock, sub.getItemDamage()));
                }
                continue;
            }
            builder.add((Object)BlockChopper.createItemStack(block, baseBlock, stack.getItemDamage()));
        }
        this.outputs = ImmutableList.of((Object)builder.build());
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = HorsePowerPlugin.jeiHelpers.getStackHelper();
        List inputs = stackHelper.expandRecipeItemStackInputs(Arrays.asList(this.recipe.getInput()));
        ingredients.setInputLists(ItemStack.class, inputs);
        if (!this.outputs.isEmpty()) {
            ingredients.setOutputLists(ItemStack.class, this.outputs);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean isOutputBlock(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack output : this.recipe.outputBlocks) {
            if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = (List)ingredients.getOutputs(ItemStack.class).get(0);
        IFocus ifocus = recipeLayout.getFocus();
        Object focusObj = ifocus.getValue();
        if (focusObj instanceof ItemStack) {
            ItemStack base;
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(ItemStack.class);
            ItemStack focus = (ItemStack)focusObj;
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.isOutputBlock(focus)) {
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.recipe.getSimpleRecipeOutput().getItem());
                ItemStack outputFocus = BlockChopper.createItemStack(block, Block.getBlockFromItem((Item)focus.getItem()), focus.getItemDamage());
                guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)outputFocus));
            } else if (mode == IFocus.Mode.OUTPUT && !(base = new ItemStack(focus.hasTagCompound() ? focus.getTagCompound().getCompoundTag("textureBlock") : new NBTTagCompound())).isEmpty()) {
                guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)base));
            }
        }
        HorsePowerPlugin.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.getWidth(), this.getHeight());
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

