/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;

public class TileEntityChopper
extends TileEntityHPHorseBase {
    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;
    private float visualWindup = 0.0f;
    private float oldVisualWindup = -1.0f;
    private IItemHandler handlerSide = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);

    public TileEntityChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentWindup", this.currentWindup);
        compound.func_74768_a("chopTime", this.currentItemChopTime);
        compound.func_74768_a("totalChopTime", this.totalItemChopTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentWindup = compound.func_74762_e("currentWindup");
        if (this.inventory.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemChopTime = compound.func_74762_e("chopTime");
            this.totalItemChopTime = compound.func_74762_e("totalChopTime");
        } else {
            this.currentItemChopTime = 0;
            this.totalItemChopTime = 1;
        }
    }

    public IExtendedBlockState getExtendedState(IExtendedBlockState state) {
        ItemStack stack;
        String side_texture = this.getTileData().func_74779_i("side_texture");
        String top_texture = this.getTileData().func_74779_i("top_texture");
        if ((side_texture.isEmpty() || top_texture.isEmpty()) && !(stack = new ItemStack(this.getTileData().func_74775_l("textureBlock"))).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state1 = block.func_176203_a(stack.func_77960_j());
            side_texture = Utils.getTextureFromBlockstate(state1).func_94215_i();
            top_texture = Utils.getTopTextureFromBlockstate(state1).func_94215_i();
            this.getTileData().func_74778_a("side_texture", side_texture);
        }
        if (!side_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockChopper.SIDE_TEXTURE, (Object)side_texture);
        }
        if (!top_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockChopper.TOP_TEXTURE, (Object)top_texture);
        }
        state = (IExtendedBlockState)state.func_177226_a((IProperty)BlockChopper.FACING, (Comparable)this.getForward());
        state = (IExtendedBlockState)state.func_177226_a(BlockChopper.PART, state.func_177229_b(BlockChopper.PART));
        return state;
    }

    public void setTextureBlock(NBTTagCompound textureBlock) {
        this.getTileData().func_74782_a("textureBlock", (NBTBase)textureBlock);
    }

    public NBTTagCompound getTextureBlock() {
        return this.getTileData().func_74775_l("textureBlock");
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack) && this.inventory.func_70301_a(1).func_190926_b() && this.inventory.func_70301_a(0).func_190926_b();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float windup = Configs.pointsForWindup > 0 ? (float)Configs.pointsForWindup : 1.0f;
        this.visualWindup = -0.74f + 0.74f * ((float)this.currentWindup / (windup - 1.0f));
    }

    @Override
    public boolean targetReached() {
        ++this.currentWindup;
        if (this.currentWindup >= Configs.pointsForWindup) {
            this.currentWindup = 0;
            ++this.currentItemChopTime;
            if (this.currentItemChopTime >= this.totalItemChopTime) {
                this.currentItemChopTime = 0;
                this.totalItemChopTime = HPRecipes.instance().getChoppingTime(this.inventory.func_70301_a(0));
                this.chopItem();
                return true;
            }
        }
        this.func_70296_d();
        return false;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.inventory.func_70301_a(index);
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.inventory.func_70301_a(1).func_190926_b()) {
            this.func_70296_d();
        }
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemChopTime = HPRecipes.instance().getChoppingTime(stack);
            this.currentItemChopTime = 0;
            this.currentWindup = 0;
            this.func_70296_d();
        }
    }

    private void chopItem() {
        if (this.canWork()) {
            ItemStack input = this.inventory.func_70301_a(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.inventory.func_70301_a(1);
            if (output.func_190926_b()) {
                this.setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
            this.func_70296_d();
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.inventory.func_70301_a(0));
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getChoppingBlockRecipe(this.inventory.func_70301_a(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopTime;
            }
            case 1: {
                return this.currentItemChopTime;
            }
            case 2: {
                return this.currentWindup;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopTime = value;
                break;
            }
            case 1: {
                this.currentItemChopTime = value;
            }
            case 2: {
                this.currentWindup = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "container.chopper";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    public float getVisualWindup() {
        return this.visualWindup;
    }

    public float getOldVisualWindup() {
        return this.oldVisualWindup;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.valid) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation(Localization.INFO.CHOPPING_INVALID.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap = super.getCapability(capability, facing);
        return (T)(cap != null ? cap : (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.handlerSide : null));
    }
}

