package se.gory_moon.horsepower.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;

public class TileEntityHandGrindstone extends TileEntityHPBase implements ITickable {

    private int currentItemMillTime;
    private int totalItemMillTime;

    private final int ticksPerRotation = 18;
    private float visibleRotation = 0;
    private int currentTicks = 0;
    private int rotation = 0;


    public TileEntityHandGrindstone() {
        super(3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", currentItemMillTime);
        compound.func_74768_a("totalMillTime", totalItemMillTime);
        compound.func_74768_a("currentRotation", rotation);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        if (inventory.func_70301_a(0).func_190916_E() > 0) {
            currentItemMillTime = compound.func_74762_e("millTime");
            totalItemMillTime = compound.func_74762_e("totalMillTime");
            rotation = compound.func_74762_e("currentRotation");
        } else {
            currentItemMillTime = 0;
            totalItemMillTime = 1;
            rotation = 0;
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(inventory.func_70301_a(0), true);
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getGrindstoneRecipe(inventory.func_70301_a(0), true);
    }

    private void millItem() {
        if (!field_145850_b.field_72995_K && canWork()) {
            HPRecipeBase recipe = getRecipe();
            ItemStack result = recipe.getOutput();
            ItemStack secondary = recipe.getSecondary();

            ItemStack input = inventory.func_70301_a(0);
            ItemStack output = inventory.func_70301_a(1);
            ItemStack secondaryOutput = inventory.func_70301_a(2);

            if (output.func_190926_b()) {
                setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }
            processSecondaries(func_145831_w(), secondary, secondaryOutput, recipe, this);

            input.func_190918_g(1);
        }
    }

    public static void processSecondaries(World world, ItemStack secondary, ItemStack secondaryOutput, HPRecipeBase recipe, TileEntityHPBase teBase) {
        if (!secondary.func_190926_b()) {
            int recipeChance = recipe.getSecondaryChance();
            if (recipeChance >= 100 || world.field_73012_v.nextInt(100) < recipeChance) {
                if (secondaryOutput.func_190926_b()) {
                    teBase.setInventorySlotContents(2, secondary.func_77946_l());
                } else if (secondaryOutput.func_77969_a(secondary)) {
                    secondaryOutput.func_190917_f(secondary.func_190916_E());
                }
            }
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (inventory.func_70301_a(0).func_190926_b())
            currentItemMillTime = 0;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = inventory.func_70301_a(index);
        super.setInventorySlotContents(index, stack);

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag) {
            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack, true);
            currentItemMillTime = 0;
        }
        func_70296_d();
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack, true);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0:
                return totalItemMillTime;
            case 1:
                return currentItemMillTime;
            default:
                return 0;
        }
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0:
                totalItemMillTime = value;
                break;
            case 1:
                currentItemMillTime = value;
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public String getName() {
        return "container.hand_mill";
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    public void turn() {
        if (func_145831_w().field_72995_K)
            return;

        if (rotation < 3 && canWork()) {
            rotation += ticksPerRotation;
            func_70296_d();
        }
    }

    @Override
    public void func_73660_a() {
        if (rotation > 0) {

            visibleRotation = (visibleRotation - 360 / (ticksPerRotation)) % -360;
            currentTicks++;
            if (currentTicks >= ticksPerRotation) {
                currentTicks -= ticksPerRotation;

                currentItemMillTime += Configs.pointsPerRotation;

                if (currentItemMillTime >= totalItemMillTime) {
                    currentItemMillTime = 0;

                    millItem();
                    totalItemMillTime = HPRecipes.instance().getGrindstoneTime(inventory.func_70301_a(0), true);
                }
                func_70296_d();
            }

            rotation--;
        } else {
            visibleRotation = 0;
        }
    }

    public float getVisibleRotation() {
        return visibleRotation;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}
