/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.property.PropertyUnlistedString;
import se.gory_moon.horsepower.client.renderer.modelvariants.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChopper
extends BlockHPBase
implements IProbeInfoAccessor {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing");
    public static final PropertyEnum<ChopperModels> PART = PropertyEnum.create((String)"part", ChopperModels.class);
    public static final PropertyUnlistedString SIDE_TEXTURE = new PropertyUnlistedString("side_texture");
    public static final PropertyUnlistedString TOP_TEXTURE = new PropertyUnlistedString("top_texture");
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockChopper() {
        super(Material.WOOD);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setSoundType(SoundType.WOOD);
        this.setRegistryName("chopper");
        this.setUnlocalizedName("chopper");
        this.setCreativeTab(HorsePowerMod.creativeTab);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityChopper();
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasCustomBreakingProgress(IBlockState state) {
        return true;
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PART, FACING}, new IUnlistedProperty[]{SIDE_TEXTURE, TOP_TEXTURE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntityHPBase tile = this.getTileEntity(world, pos);
        if (tile != null && tile instanceof TileEntityChopper) {
            return ((TileEntityChopper)tile).getExtendedState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TileEntity te = world.getTileEntity(pos);
        if (te != null && te instanceof TileEntityChopper) {
            TileEntityChopper table = (TileEntityChopper)te;
            NBTTagCompound tag = item.hasTagCompound() ? item.getTagCompound() : new NBTTagCompound();
            NBTTagCompound data = table.getTextureBlock();
            if (!data.hasNoTags()) {
                tag.setTag("textureBlock", (NBTBase)data);
            }
            if (!tag.hasNoTags()) {
                item.setTagCompound(tag);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.getItemDropped(state, world.rand, 0);
        if (item != Items.AIR) {
            drops.add(new ItemStack(item, 1, this.damageDropped(state)));
        }
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.isRemote && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.getItem() != Item.getItemFromBlock((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            for (ItemStack item : items) {
                if (!(worldIn.rand.nextFloat() <= chance)) continue;
                BlockChopper.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isRemote) {
            EnumFacing enumfacing = (EnumFacing)state.getValue((IProperty)FACING);
            worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)enumfacing).withProperty(PART, (Comparable)((Object)ChopperModels.BASE)), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()).withProperty(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.getFront((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing).withProperty(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
        NBTTagCompound tag = stack.hasTagCompound() ? stack.getTagCompound() : new NBTTagCompound();
        TileEntityHPBase tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        NBTTagCompound baseTag = tag != null ? tag.getCompoundTag("textureBlock") : new NBTTagCompound();
        ((TileEntityChopper)tile).setTextureBlock(baseTag);
        tile.setForward(placer.getHorizontalFacing().getOpposite());
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    public static ItemStack createItemStack(BlockChopper table, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.writeToNBT(subTag);
            tag.setTag("textureBlock", (NBTBase)subTag);
            stack.setTagCompound(tag);
        }
        return stack;
    }

    public void getSubBlocks(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)"logWood")) {
            Block block = BlockChopper.getBlockFromItem((Item)stack.getItem());
            int blockMeta = stack.getItemDamage();
            if (blockMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.create();
                block.getSubBlocks(stack.getItem(), null, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add((Object)BlockChopper.createItemStack(this, BlockChopper.getBlockFromItem((Item)subBlock.getItem()), subBlock.getItemDamage()));
                }
                continue;
            }
            list.add((Object)BlockChopper.createItemStack(this, block, blockMeta));
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.LOCATION.translate(new String[0]));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.USE.translate(new String[0]));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.getTileEntity(data.getPos());
        if (tileEntity instanceof TileEntityChopper) {
            TileEntityChopper te = (TileEntityChopper)tileEntity;
            double totalWindup = Configs.pointsForWindup > 0 ? (double)Configs.pointsForWindup : 1.0;
            probeInfo.progress((long)((double)te.getField(2) / totalWindup * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.WINDUP_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            if (te.getField(0) > 1) {
                probeInfo.progress((long)((double)te.getField(1) / (double)te.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            }
        }
    }
}

