package se.gory_moon.horsepower.tileentity;

import net.minecraft.block.BlockDirectional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import se.gory_moon.horsepower.blocks.BlockHPBase;

import javax.annotation.Nullable;

public class TileEntityFiller extends TileEntity {

    public TileEntityHPBase getFilledTileEntity() {
        BlockPos pos = getFilledPos();
        TileEntity tileEntity = func_145831_w().func_175625_s(pos);
        if (tileEntity instanceof TileEntityHPBase) {
            return (TileEntityHPBase) tileEntity;
        }
        return null;
    }

    public BlockPos getFilledPos() {
        IBlockState state = func_145831_w().func_180495_p(func_174877_v());
        if (!(state.func_177230_c() instanceof BlockHPBase)) return func_174877_v();
        EnumFacing facing = state.func_177229_b(BlockDirectional.field_176387_N);
        return field_174879_c.func_177972_a(facing);
    }

    @Override
    public void func_70296_d() {
        TileEntityHPBase te = getFilledTileEntity();
        if (te != null)
            te.func_70296_d();
        super.func_70296_d();
    }

    @Override
    public ITextComponent func_145748_c_() {
        TileEntityHPBase te = getFilledTileEntity();
        if (te != null)
            return te.func_145748_c_();
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntityHPBase te = getFilledTileEntity();
        if (te != null)
            return te.hasCapability(capability, facing);
        return super.hasCapability(capability, facing);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getCapability(net.minecraftforge.common.capabilities.Capability<T> capability, @javax.annotation.Nullable net.minecraft.util.EnumFacing facing) {
        TileEntityHPBase te = getFilledTileEntity();
        if (te != null)
            return te.getCapability(capability, facing);
        return super.getCapability(capability, facing);
    }
}
