/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util;

import net.minecraft.util.text.translation.I18n;

public final class Localization {
    private static String translateString(String key, String ... vars) {
        String result = Localization.translateToLocal(key);
        for (int i = 0; i < vars.length; ++i) {
            String optionCheck = "[%" + (i + 1) + "->";
            int pos = result.indexOf(optionCheck);
            if (pos != -1) {
                int pickedOption;
                int endPos = result.indexOf("]");
                if (endPos == -1) continue;
                String[] options = result.substring(pos + optionCheck.length(), endPos).split("\\|");
                int n = pickedOption = vars[i].equals("1") ? 1 : 0;
                if (options.length <= pickedOption) continue;
                String opt = options[pickedOption];
                result = result.substring(0, pos) + opt + result.substring(endPos + 1);
                --i;
                continue;
            }
            result = result.replace("[%" + (i + 1) + "]", vars[i]);
        }
        return result;
    }

    private static String translateToLocal(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static enum TOP {
        GRINDSTONE_PROGRESS,
        WINDUP_PROGRESS,
        CHOPPING_PROGRESS;


        public String translate(String ... vars) {
            return Localization.translateString(this.key(), vars);
        }

        public String key() {
            return "gui.horsepower.top." + this.toString().toLowerCase().replaceAll("_", ".");
        }
    }

    public static enum WAILA {
        GRINDSTONE_PROGRESS,
        WINDUP_PROGRESS,
        CHOPPING_PROGRESS,
        SHOW_ITEMS;


        public String translate(String ... vars) {
            return Localization.translateString(this.key(), vars);
        }

        public String key() {
            return "gui.horsepower.waila." + this.toString().toLowerCase().replaceAll("_", ".");
        }
    }

    public static enum GUI {
        CATEGORY_GRINDING,
        CATEGORY_HAND_GRINDING,
        CATEGORY_CHOPPING;


        public String translate(String ... vars) {
            return Localization.translateString(this.key(), vars);
        }

        public String key() {
            return "gui.horsepower.jei." + this.toString().toLowerCase().replaceAll("_", ".");
        }
    }

    public static enum INFO {
        GRINDSTONE_INVALID,
        CHOPPING_INVALID;


        public String translate(String ... vars) {
            return Localization.translateString(this.key(), vars);
        }

        public String key() {
            return "info.horsepower:" + this.toString().toLowerCase().replaceAll("_", ".");
        }
    }

    public static class ITEM {

        public static enum HORSE_CHOPPING {
            SIZE,
            LOCATION,
            USE;


            public String translate(String ... vars) {
                return Localization.translateString("item.horsepower:chopping.description." + this.toString().toLowerCase(), vars);
            }
        }

        public static enum HAND_GRINDSTONE {
            INFO;


            public String translate(String ... vars) {
                return Localization.translateString("item.horsepower:hand_grindstone.description." + this.toString().toLowerCase(), vars);
            }
        }

        public static enum HORSE_GRINDSTONE {
            SIZE,
            LOCATION,
            USE;


            public String translate(String ... vars) {
                return Localization.translateString("item.horsepower:grindstone.description." + this.toString().toLowerCase(), vars);
            }
        }
    }
}

