package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.client.renderer.modelvariants.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;

public class TileEntityChopperRender extends TileEntityHPBaseRenderer<TileEntityChopper> {

    @Override
    public void func_180535_a(TileEntityChopper te, double x, double y, double z, float partialTicks, int destroyStage) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;
        IBlockState bladeState = blockState.func_177226_a(BlockChopper.PART, ChopperModels.BLADE);
        if (!(bladeState.func_177230_c() instanceof BlockHPBase)) return;
        IBakedModel bladeModel = dispatcher.func_175023_a().func_178125_b(bladeState);

        preDestroyRender(destroyStage);
        setRenderSettings();

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        // The translation ensures the vertex buffer positions are relative to 0,0,0 instead of the block pos
        // This makes the translations that follow much easier
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p() );

        if (destroyStage >= 0) {
            buffer.func_78914_f();
            renderBlockDamage(bladeState, te.func_174877_v(), getDestroyBlockIcon(destroyStage), te.func_145831_w());
        } else
            dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), bladeModel, blockState, te.func_174877_v(), buffer, false );

        buffer.func_178969_c( 0, 0, 0 );

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );

        // Apply GL transformations relative to the center of the block: 1) TE rotation and 2) crank rotation
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        GlStateManager.func_179109_b( 0, te.getVisualWindup(), 0 );
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        buffer.func_178969_c(0.0D, 0.0D, 0.0D);
        postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();

        renderLeach(x + 0.5, y + 2.9 + te.getVisualWindup(), z + 0.5, x + 0.5, y + 0.2, z + 0.5, x + 0.5, y + 1.7, z + 0.5);

        if (te.hasWorker())
            renderLeash(te.getWorker(), x, y, z, 0D, 1.1D, 0D, partialTicks, te.func_174877_v());

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x, y, z);
        renderStillItem(te, te.getStackInSlot(0), 0.5F, 0.54F, 0.5F, 1.3F);
        GlStateManager.func_179121_F();

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x, y, z);
        renderStillItem(te, te.getStackInSlot(1), 0.5F, 0.54F, 0.5F, 1.3F);
        GlStateManager.func_179121_F();

        super.func_180535_a(te, x, y + 1, z, partialTicks, destroyStage);
    }

}
