/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.client.renderer.TileEntityHPBaseRenderer;
import se.gory_moon.horsepower.client.renderer.modelvariants.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;

public class TileEntityChopperRender
extends TileEntityHPBaseRenderer<TileEntityChopper> {
    public void renderTileEntityAt(TileEntityChopper te, double x, double y, double z, float partialTicks, int destroyStage) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer buffer = tessellator.getBuffer();
        BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBlockState blockState = te.getWorld().getBlockState(te.getPos());
        if (!(blockState.getBlock() instanceof BlockHPBase)) {
            return;
        }
        IBlockState bladeState = blockState.withProperty(BlockChopper.PART, (Comparable)((Object)ChopperModels.BLADE));
        IBakedModel bladeModel = dispatcher.getBlockModelShapes().getModelForState(bladeState);
        this.preDestroyRender(destroyStage);
        this.setRenderSettings();
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        buffer.setTranslation((double)(-te.getPos().getX()), (double)(-te.getPos().getY()), (double)(-te.getPos().getZ()));
        if (destroyStage >= 0) {
            buffer.noColor();
            this.renderBlockDamage(bladeState, te.getPos(), TileEntityChopperRender.getDestroyBlockIcon(destroyStage), (IBlockAccess)te.getWorld());
        } else {
            dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), bladeModel, blockState, te.getPos(), buffer, false);
        }
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.translate((float)0.0f, (float)te.getVisualWindup(), (float)0.0f);
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.draw();
        GlStateManager.popMatrix();
        buffer.setTranslation(0.0, 0.0, 0.0);
        this.postDestroyRender(destroyStage);
        RenderHelper.enableStandardItemLighting();
        this.renderLeach(x + 0.5, y + 2.9 + (double)te.getVisualWindup(), z + 0.5, x + 0.5, y + 0.2, z + 0.5, x + 0.5, y + 1.7, z + 0.5);
        if (te.hasWorker()) {
            this.renderLeash(te.getWorker(), x, y, z, 0.0, 1.1, 0.0, partialTicks, te.getPos());
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        this.renderStillItem(te, te.getStackInSlot(0), 0.5f, 0.54f, 0.5f, 1.3f);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        this.renderStillItem(te, te.getStackInSlot(1), 0.5f, 0.54f, 0.5f, 1.3f);
        GlStateManager.popMatrix();
        super.renderTileEntityAt((TileEntity)te, x, y + 1.0, z, partialTicks, destroyStage);
    }
}

