package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.blocks.BlockHandGrindstone;
import se.gory_moon.horsepower.client.renderer.modelvariants.HandGrindstoneModels;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;

public class TileEntityHandGrindstoneRender extends TileEntityHPBaseRenderer<TileEntityHandGrindstone> {

    @Override
    public void func_180535_a(TileEntityHandGrindstone te, double x, double y, double z, float partialTicks, int destroyStage) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        IBlockState centerState = blockState.func_177226_a(BlockHandGrindstone.PART, HandGrindstoneModels.CENTER);
        IBakedModel centerModel = dispatcher.func_175023_a().func_178125_b(centerState);

        preDestroyRender(destroyStage);
        setRenderSettings();

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        // The translation ensures the vertex buffer positions are relative to 0,0,0 instead of the block pos
        // This makes the translations that follow much easier
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p() );

        if (destroyStage >= 0) {
            buffer.func_78914_f();
            renderBlockDamage(centerState, te.func_174877_v(), getDestroyBlockIcon(destroyStage), te.func_145831_w());
        } else
            dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), centerModel, centerState, te.func_174877_v(), buffer, false );

        buffer.func_178969_c( 0, 0, 0 );

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );

        // Apply GL transformations relative to the center of the block: 1) TE rotation and 2) crank rotation
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        FacingToRotation.get( te.getForward()).glRotateCurrentMat();
        float rotation = te.getVisibleRotation();
        GlStateManager.func_179114_b( rotation, 0, 1, 0 );
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        buffer.func_178969_c(0.0D, 0.0D, 0.0D);
        postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();

        renderItemWithFacing(te.func_145831_w(), te, te.func_70301_a(0), x, y, z, 0.5F, 0.7F, 0.8F, 0.7F);
        renderItemWithFacing(te.func_145831_w(), te, te.func_70301_a(1), x, y, z, 0.5F, 0.7F, 0.2F, 0.7F);

        super.func_180535_a(te, x, y, z, partialTicks, destroyStage);
    }

}
