/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.util.IEventHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tweaker.ITweakerPlugin;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower")
public class TweakerPluginImpl
implements ITweakerPlugin,
IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
    private static List<IUndoableAction> actions = Lists.newArrayList();

    public TweakerPluginImpl() {
        MineTweakerImplementationAPI.onReloadEvent((IEventHandler)this);
    }

    @Override
    public void applyTweaker() {
        for (IUndoableAction action : actions) {
            action.apply();
        }
    }

    public void handle(MineTweakerImplementationAPI.ReloadEvent reloadEvent) {
        actions.clear();
    }

    @Override
    public void register() {
        MineTweakerAPI.registerClass(TweakerPluginImpl.class);
    }

    @ZenMethod
    public static void addGrindstoneRecipe(IIngredient input, IItemStack output, int time) {
        List items = input.getItems();
        if (items == null) {
            MineTweakerAPI.logError((String)("Cannot turn " + input.toString() + " into a furnace recipe"));
        }
        ItemStack[] items2 = MineTweakerMC.getItemStacks((List)items);
        ItemStack output2 = MineTweakerMC.getItemStack((IItemStack)output);
        AddGrindstoneRecipe recipe = new AddGrindstoneRecipe(input, items2, output2, time);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        actions.add(recipe);
    }

    @ZenMethod
    public static void removeGrindstoneReicpe(IIngredient output) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            GrindstoneRecipe recipe = HPRecipes.instance().getGrindstoneRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)MineTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemoveGrindstoneRecipe recipe = new RemoveGrindstoneRecipe(toRemove, removeIndex);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        actions.add(recipe);
    }

    private static class RemoveGrindstoneRecipe
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<GrindstoneRecipe> recipes;

        private RemoveGrindstoneRecipe(List<GrindstoneRecipe> recipes, List<Integer> removingIndices) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
        }

        public void apply() {
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                HPRecipes.instance().getGrindstoneRecipes().remove(this.removingIndices.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipes.get(i), "horsepower.grinding");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(HPRecipes.instance().getGrindstoneRecipes().size(), this.removingIndices.get(i));
                HPRecipes.instance().getGrindstoneRecipes().add(index, this.recipes.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipes.get(i), "horsepower.grinding");
            }
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " grindstone recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.recipes.size() + " grindstone recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddGrindstoneRecipe
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final int time;

        public AddGrindstoneRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, int time) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.time = time;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                GrindstoneRecipe recipe = new GrindstoneRecipe(stack, this.output, this.time);
                HPRecipes.instance().addGrindstoneRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe, "horsepower.grinding");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack stack : this.input) {
                GrindstoneRecipe recipe = new GrindstoneRecipe(stack, this.output, this.time);
                HPRecipes.instance().removeGrindstoneRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe, "horsepower.grinding");
            }
        }

        public String describe() {
            return "Adding grindstone recipe for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing grindstone recipe for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

