/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.client.renderer.FacingToRotation;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public abstract class TileEntityHPBaseRenderer<T extends TileEntityHPBase>
extends TileEntitySpecialRenderer<T> {
    protected void renderItem(World world, ItemStack stack, float x, float y, float z, float scale) {
        RenderItem itemRenderer = Minecraft.getMinecraft().getRenderItem();
        if (stack != null) {
            GlStateManager.translate((float)x, (float)y, (float)z);
            EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, stack);
            entityitem.getEntityItem().setCount(1);
            entityitem.hoverStart = 0.0f;
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            GlStateManager.rotate((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scale((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
            GlStateManager.pushAttrib();
            RenderHelper.enableStandardItemLighting();
            itemRenderer.renderItem(entityitem.getEntityItem(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.popAttrib();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }

    protected void renderItemWithFacing(World world, TileEntityHPBase tile, ItemStack stack, double ox, double oy, double oz, float x, float y, float z, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)ox, (double)oy, (double)oz);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(tile.getForward()).glRotateCurrentMat();
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        this.renderItem(tile.getWorld(), stack, x, y, z, scale);
        GlStateManager.popMatrix();
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityCreature entity, double x, double y, double z, float entityYaw, float partialTicks, BlockPos pos) {
        if (entity != null) {
            y -= 0.7000000000000001;
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = -1.0;
            double d9 = this.interpolateValue(entity.prevRenderYawOffset, entity.renderYawOffset, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)entity.width * 0.4;
            d3 = Math.sin(d9) * (double)entity.width * 0.4;
            double d6 = this.interpolateValue(entity.prevPosX, entity.posX, partialTicks) + d2;
            double d7 = this.interpolateValue(entity.prevPosY + (double)entity.getEyeHeight() * 1.1, entity.posY + (double)entity.getEyeHeight() * 1.1, partialTicks) - d4 * 0.5 - 0.25;
            double d8 = this.interpolateValue(entity.prevPosZ, entity.posZ, partialTicks) + d3;
            d2 = 0.5;
            d3 = 0.5;
            double d10 = (double)pos.getX() + d2;
            double d11 = pos.getY();
            double d12 = (double)pos.getZ() + d3;
            x += d2;
            z += d3;
            double d13 = (float)(d6 - d10);
            double d14 = (float)(d7 - d11);
            double d15 = (float)(d8 - d12);
            GlStateManager.disableTexture2D();
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            vertexbuffer.begin(5, DefaultVertexFormats.POSITION_COLOR);
            for (int j = 0; j <= 24; ++j) {
                float f = 0.5f;
                float f1 = 0.4f;
                float f2 = 0.3f;
                if (j % 2 == 0) {
                    f *= 0.7f;
                    f1 *= 0.7f;
                    f2 *= 0.7f;
                }
                float f3 = (float)j / 24.0f;
                vertexbuffer.pos(x + d13 * (double)f3 + 0.0, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), z + d15 * (double)f3).color(f, f1, f2, 1.0f).endVertex();
                vertexbuffer.pos(x + d13 * (double)f3 + 0.025, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f3).color(f, f1, f2, 1.0f).endVertex();
            }
            tessellator.draw();
            vertexbuffer.begin(5, DefaultVertexFormats.POSITION_COLOR);
            for (int k = 0; k <= 24; ++k) {
                float f4 = 0.5f;
                float f5 = 0.4f;
                float f6 = 0.3f;
                if (k % 2 == 0) {
                    f4 *= 0.7f;
                    f5 *= 0.7f;
                    f6 *= 0.7f;
                }
                float f7 = (float)k / 24.0f;
                vertexbuffer.pos(x + d13 * (double)f7 + 0.0, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f7).color(f4, f5, f6, 1.0f).endVertex();
                vertexbuffer.pos(x + d13 * (double)f7 + 0.025, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), z + d15 * (double)f7 + 0.025).color(f4, f5, f6, 1.0f).endVertex();
            }
            tessellator.draw();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture2D();
            GlStateManager.enableCull();
        }
    }
}

