/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.items.ModItems;
import se.gory_moon.horsepower.jei.DummyJeiPlugin;
import se.gory_moon.horsepower.jei.IJeiPlugin;
import se.gory_moon.horsepower.proxy.CommonProxy;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tweaker.DummyTweakPluginImpl;
import se.gory_moon.horsepower.tweaker.ITweakerPlugin;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;

@Mod(modid="horsepower", version="1.1.2", name="Horse Power", acceptedMinecraftVersions="[1.11.2]", dependencies="after:crafttweaker;after:jei;after:waila;after:theoneprobe;")
@Mod.EventBusSubscriber
public class HorsePowerMod {
    @Mod.Instance(value="horsepower")
    public static HorsePowerMod instance;
    @SidedProxy(clientSide="se.gory_moon.horsepower.proxy.ClientProxy", serverSide="se.gory_moon.horsepower.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static ITweakerPlugin tweakerPlugin;
    public static IJeiPlugin jeiPlugin;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"se.gory_moon.horsepower.waila.Provider.callbackRegister")) {
            logger.info("Loaded Waila Integration");
        }
        ModBlocks.registerTileEntities();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModItems.registerRecipes();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            tweakerPlugin = new TweakerPluginImpl();
            tweakerPlugin.register();
        } else {
            tweakerPlugin = new DummyTweakPluginImpl();
        }
        HPRecipes.instance().reloadRecipes();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public String getName() {
                return "horsepower";
            }

            public String getUsage(ICommandSender sender) {
                return "/horsepower reload";
            }

            public int getRequiredPermissionLevel() {
                return 2;
            }

            public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (args.length != 1 || !"reload".equals(args[0])) {
                    throw new WrongUsageException("/horsepower reload", new Object[0]);
                }
                ConfigManager.sync((String)"horsepower", (Config.Type)Config.Type.INSTANCE);
                HPRecipes.instance().reloadRecipes();
                sender.sendMessage((ITextComponent)new TextComponentTranslation("commands.horsepower.reload", new Object[0]));
            }

            public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return args.length == 1 ? Lists.asList((Object)"reload", (Object[])new String[0]) : Lists.newArrayList();
            }
        });
    }

    static {
        jeiPlugin = new DummyJeiPlugin();
        logger = LogManager.getLogger((String)"HorsePower");
    }
}

