package se.gory_moon.horsepower.blocks;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.lib.Constants;
import se.gory_moon.horsepower.util.Colors;
import se.gory_moon.horsepower.util.Utils;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

@Optional.Interface(iface = "mcjty.theoneprobe.api.IProbeInfoAccessor", modid = "theoneprobe")
public class BlockGrindstone extends Block implements IProbeInfoAccessor {

    private static boolean keepInventory = false;
    public static final PropertyBool FILLED = PropertyBool.func_177716_a("filled");
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 8D/16D, 1.0D);
    private static final AxisAlignedBB BOUNDING_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 13D/16D, 1.0D);

    public BlockGrindstone() {
        super(Material.field_151576_e);
        func_149711_c(1.5F);
        func_149752_b(10F);
        func_149672_a(SoundType.field_185851_d);
        setRegistryName(Constants.GRINDSTONE_BLOCK);
        func_149663_c(Constants.GRINDSTONE_BLOCK);
        func_149647_a(CreativeTabs.field_78031_c);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_AABB;
    }

    @Nullable
    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGrindstone();
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);

        if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K) {
            TileEntityGrindstone te = getTileEntity(worldIn, pos);

            if (te != null) {
                InventoryHelper.func_180175_a(worldIn, pos, te);
                if (te.hasWorker())
                    InventoryHelper.func_180173_a(worldIn, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), new ItemStack(Items.field_151058_ca));
            }
        }
    }

    private TileEntityGrindstone getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityGrindstone ? (TileEntityGrindstone)tileentity : null;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, new IProperty[] {FILLED});
    }

    /**
     * Convert the BlockState into the correct metadata value
     */
    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(FILLED).booleanValue() ? 1: 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(FILLED, meta == 1);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public static void setState(boolean filled, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        worldIn.func_180501_a(pos, ModBlocks.BLOCK_GRINDSTONE.func_176223_P().func_177226_a(FILLED, filled), 3);
        keepInventory = false;

        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
            tileentity.func_145829_t();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!keepInventory && !worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);

            if (tileentity instanceof TileEntityGrindstone) {
                worldIn.func_175666_e(pos, this);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntityGrindstone tileEntityGrindstone = (TileEntityGrindstone) worldIn.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();

        EntityCreature creature = null;
        ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
        search: for (Class<? extends Entity> clazz: clazzes) {
            for (Object entity : worldIn.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0D, (double)y - 7.0D, (double)z - 7.0D, (double)x + 7.0D, (double)y + 7.0D, (double)z + 7.0D))){
                if (entity instanceof EntityCreature) {
                    EntityCreature tmp = (EntityCreature) entity;
                    if ((tmp.func_110167_bD() && tmp.func_110166_bE() == playerIn)) {
                        creature = tmp;
                        break search;
                    }
                }
            }
        }
        if (stack.func_77973_b() instanceof ItemLead && creature != null || creature != null) {
            if (!tileEntityGrindstone.hasWorker()) {
                creature.func_110160_i(true, false);
                tileEntityGrindstone.setWorker(creature);
                return true;
            } else {
                return false;
            }
        } else if (!stack.func_190926_b() && tileEntityGrindstone.func_94041_b(0, stack)) {
            ItemStack itemStack = tileEntityGrindstone.func_70301_a(0);
            boolean flag = false;

            if (itemStack.func_190926_b()) {
                tileEntityGrindstone.func_70299_a(0, stack.func_77946_l());
                stack.func_190920_e(0);
                flag = true;
            } else if (TileEntityGrindstone.canCombine(itemStack, stack)) {
                int i = stack.func_77976_d() - itemStack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemStack.func_190917_f(j);
                flag = j > 0;
            }

            if (flag)
                return true;
        }

        ItemStack result = tileEntityGrindstone.func_70304_b(1);
        if (result.func_190926_b() && stack.func_190926_b() && hand != EnumHand.OFF_HAND) {
            result = tileEntityGrindstone.func_70304_b(0);
            BlockGrindstone.setState(false, worldIn, pos);
        }

        if (result.func_190926_b()) {
            if (!stack.func_190926_b())
                return false;

            tileEntityGrindstone.setWorkerToPlayer(playerIn);
        }

        if (stack.func_190926_b()) {
            playerIn.func_184611_a(hand, result);
        } else if (playerIn.func_191521_c(result)) {
            playerIn.func_71019_a(result, false);
        }

        tileEntityGrindstone.func_70296_d();
        return true;
    }

    @Override
    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.MILL.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.MILL.LOCATION.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.MILL.USE.translate());
    }

    // The One Probe Integration
    @Optional.Method(modid = "theoneprobe")
    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof TileEntityGrindstone) {
            TileEntityGrindstone te = (TileEntityGrindstone) tileEntity;
            probeInfo.progress((long) ((((double)te.func_174887_a_(1)) / ((double)te.func_174887_a_(0))) * 100L), 100L, new ProgressStyle().suffix("%"));
        }
    }
}
