/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;

public class GrindstoneRecipes {
    private static GrindstoneRecipes INSTANCE = new GrindstoneRecipes();
    private final ArrayList<GrindstoneRecipe> grindstoneRecipes = Lists.newArrayList();

    public static GrindstoneRecipes instance() {
        return INSTANCE;
    }

    private GrindstoneRecipes() {
    }

    public void reloadRecipes() {
        HorsePowerMod.jeiPlugin.removeRecipe();
        this.grindstoneRecipes.clear();
        for (int i = 0; i < Configs.grindstoneRecipes.length; ++i) {
            String[] comp = Configs.grindstoneRecipes[i].split("-");
            ArrayList stacks = Lists.newArrayList();
            int time = -1;
            for (String item : comp) {
                if (item.contains(":")) {
                    int meta;
                    int amount;
                    String[] data = item.split("@");
                    int n = amount = data.length == 1 ? 1 : Integer.parseInt(data[1]);
                    if (data.length == 2) {
                        item = item.substring(0, item.indexOf("@"));
                    }
                    int n2 = (data = item.split(":")).length == 2 ? 0 : (meta = "*".equals(data[2]) ? Short.MAX_VALUE : Integer.parseInt(data[2]));
                    if (item.startsWith("ore:")) {
                        NonNullList items = OreDictionary.getOres((String)item.substring(4));
                        stacks.add(items);
                        continue;
                    }
                    Item item1 = Item.getByNameOrId((String)(data[0] + ":" + data[1]));
                    if (item1 == null) continue;
                    ItemStack stack = new ItemStack(item1, amount, meta);
                    stacks.add(stack);
                    continue;
                }
                try {
                    time = Integer.parseInt(item);
                }
                catch (NumberFormatException e) {
                    System.out.println("[HorsePower] Parse error with grindstone time '" + item + "' in config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() != 2 || time <= -1) continue;
            if (stacks.get(0) instanceof List) {
                for (Object stack : (List)stacks.get(0)) {
                    this.addGrindstoneRecipe((ItemStack)stack, (ItemStack)stacks.get(1), time);
                }
                continue;
            }
            this.addGrindstoneRecipe((ItemStack)stacks.get(0), (ItemStack)stacks.get(1), time);
        }
        HorsePowerMod.jeiPlugin.addRecipes();
        HorsePowerMod.tweakerPlugin.applyTweaker();
    }

    public void addGrindstoneRecipe(Block input, ItemStack stack, int time) {
        this.addGrindstoneRecipe(Item.getItemFromBlock((Block)input), stack, time);
    }

    public void addGrindstoneRecipe(Item input, ItemStack stack, int time) {
        this.addGrindstoneRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, time);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getGrindstoneResult(input) != ItemStack.EMPTY) {
            return;
        }
        this.grindstoneRecipes.add(new GrindstoneRecipe(input, output, time));
    }

    public void addGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.getGrindstoneResult(recipe.getInput()) != ItemStack.EMPTY) {
            return;
        }
        this.grindstoneRecipes.add(recipe);
    }

    public void removeGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.hasRecipe(recipe.getInput())) {
            this.grindstoneRecipes.remove(recipe);
        }
    }

    public void removeGrindstoneRecipe(ItemStack input) {
        if (this.hasRecipe(input)) {
            for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.grindstoneRecipes.remove(recipe);
            }
        }
    }

    public ItemStack getGrindstoneResult(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.EMPTY;
    }

    public boolean hasRecipe(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GrindstoneRecipe> getGrindstoneRecipes() {
        return this.grindstoneRecipes;
    }

    public int getGrindstoneTime(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 16;
    }
}

