/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.items;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.ModBlocks;

@GameRegistry.ObjectHolder(value="horsepower")
public class ModItems {
    public static final Item FLOUR = ((Item)new Item().setRegistryName("flour")).setUnlocalizedName("flour").setCreativeTab(CreativeTabs.FOOD);
    public static final Item DOUGH = ((Item)new Item().setRegistryName("dough")).setUnlocalizedName("dough").setCreativeTab(CreativeTabs.FOOD);

    public static void registerRecipes() {
        if (Configs.enableDough) {
            if (Configs.enableFlour) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(DOUGH), (Object[])new Object[]{FLOUR, Items.WATER_BUCKET});
                OreDictionary.registerOre((String)"foodFlour", (Item)FLOUR);
            }
            GameRegistry.addSmelting((Item)DOUGH, (ItemStack)new ItemStack(Items.BREAD), (float)0.0f);
            OreDictionary.registerOre((String)"foodDough", (Item)DOUGH);
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_GRINDSTONE, new Object[]{"LSL", "###", "###", Character.valueOf('S'), "stickWood", Character.valueOf('#'), "stone", Character.valueOf('L'), Items.LEAD}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_HAND_GRINSTONE, new Object[]{"  S", "###", "###", Character.valueOf('S'), "stickWood", Character.valueOf('#'), "stone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_CHOPPER, new Object[]{"LSL", "SFS", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('L'), Items.LEAD, Character.valueOf('F'), Items.FLINT, Character.valueOf('W'), "logWood"}));
        if (Configs.removeVanillaRecipes) {
            ModItems.removeRecipes();
        }
    }

    private static void removeRecipes() {
        Container dummyContainer = new Container(){

            public boolean canInteractWith(EntityPlayer entityplayer) {
                return true;
            }

            public void onCraftMatrixChanged(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "###", Character.valueOf('#'), Items.WHEAT)));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.REEDS)));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack(Blocks.BONE_BLOCK))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.BONE)));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.BEETROOT)));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.YELLOW_FLOWER, 1, BlockFlower.EnumFlowerType.DANDELION.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.POPPY.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.ALLIUM.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.HOUSTONIA.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.RED_TULIP.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.PINK_TULIP.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.SYRINGA.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.ROSE.getMeta()))));
        ModItems.removeRecipesWithRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.PAEONIA.getMeta()))));
    }

    private static InventoryCrafting setRecipe(InventoryCrafting crafting, Object ... recipeComponents) {
        crafting.clear();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = ItemStack.EMPTY;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            if (!map.containsKey(Character.valueOf(c0))) continue;
            crafting.setInventorySlotContents(l, ((ItemStack)map.get(Character.valueOf(c0))).copy());
        }
        return crafting;
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.getRecipeOutput();
            if (!ItemStack.areItemStacksEqual((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            recipes.remove(scan);
        }
    }

    private static void removeRecipesWithRecipe(IRecipe recipe) {
        ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
        if (recipe != null) {
            recipes.remove(recipe);
        }
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix) {
        for (IRecipe irecipe : CraftingManager.getInstance().getRecipeList()) {
            if (!irecipe.matches(craftMatrix, null)) continue;
            return irecipe;
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="horsepower")
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Item[] items = new Item[]{FLOUR, DOUGH};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                if (!Configs.enableFlour && item == FLOUR || !Configs.enableDough && item == DOUGH) continue;
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }
    }
}

