/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config
extends Configuration {
    public static final String CATEGORY_GAMERULES = "gamerules";
    public HashMap<String, Value> rules = new HashMap();
    public HashMap<String, Value> defaults;
    public HashMap<String, String> comments = new HashMap();

    public Config(File name) {
        super(name);
        this.rules.put("commandBlockOutput", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doDaylightCycle", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doFireTick", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doMobLoot", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doMobSpawning", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doTileDrops", new Value("true", ValueType.BOOLEAN));
        this.rules.put("keepInventory", new Value("false", ValueType.BOOLEAN));
        this.rules.put("logAdminCommands", new Value("true", ValueType.BOOLEAN));
        this.rules.put("mobGriefing", new Value("true", ValueType.BOOLEAN));
        this.rules.put("naturalRegeneration", new Value("true", ValueType.BOOLEAN));
        this.rules.put("randomTickSpeed", new Value("3", ValueType.INTEGER));
        this.rules.put("reducedDebugInfo", new Value("false", ValueType.BOOLEAN));
        this.rules.put("sendCommandFeedback", new Value("true", ValueType.BOOLEAN));
        this.rules.put("showDeathMessages", new Value("true", ValueType.BOOLEAN));
        this.comments.put("commandBlockOutput", "Whether command blocks should notify admins when they perform commands");
        this.comments.put("doDaylightCycle", "Whether time progresses");
        this.comments.put("doFireTick", "Whether fire should spread and naturally extinguish");
        this.comments.put("doMobLoot", "Whether mobs should drop items");
        this.comments.put("doMobSpawning", "Whether mobs should naturally spawn");
        this.comments.put("doTileDrops", "Whether blocks should have drops");
        this.comments.put("keepInventory", "Whether the player should keep items in their inventory after death");
        this.comments.put("logAdminCommands", "Whether to log admin commands to server log");
        this.comments.put("mobGriefing", "Whether creepers, zombies, endermen, ghasts, withers, rabbits, sheep, and villagers should be able to change blocks and whether villagers, zombies, skeletons, and zombie pigmen can pick up items");
        this.comments.put("naturalRegeneration", "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)");
        this.comments.put("randomTickSpeed", "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 will disable random ticks, higher numbers will increase random ticks");
        this.comments.put("reducedDebugInfo", "Whether the debug screen shows all or reduced infomation");
        this.comments.put("sendCommandFeedback", "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text");
        this.comments.put("showDeathMessages", "Whether a message appears in chat when a player dies");
        this.addCustomCategoryComment(CATEGORY_GAMERULES, "Set the values to 'true' or 'false' depending if you want to have the GameRule enabled or disabled");
        this.defaults = (HashMap)this.rules.clone();
    }

    public Config loadConfig() {
        this.load();
        this.syncConfigs();
        this.save();
        return this;
    }

    public void saveConfig() {
        ConfigCategory cat = this.getCategory(CATEGORY_GAMERULES);
        for (Map.Entry<String, Value> entry : this.rules.entrySet()) {
            String rule = entry.getKey();
            Value state = entry.getValue();
            Property prop = cat.get(rule);
            if (state.getType().equals((Object)ValueType.BOOLEAN)) {
                prop.setValue(state.getBooleanValue());
            } else {
                prop.setValue(state.getIntegerValue());
            }
            cat.put(rule, prop);
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    public void syncConfigs() {
        for (Map.Entry<String, Value> entry : this.rules.entrySet()) {
            String rule = entry.getKey();
            Value state = entry.getValue();
            String val = state.getType().equals((Object)ValueType.BOOLEAN) ? String.valueOf(this.get(CATEGORY_GAMERULES, rule, this.defaults.get(rule).getBooleanValue(), this.comments.get(rule)).getBoolean()) : String.valueOf(this.get(CATEGORY_GAMERULES, rule, this.defaults.get(rule).getIntegerValue(), this.comments.get(rule)).getInt());
            this.rules.put(rule, new Value(val, state.getType()));
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("GlobalGameRules")) {
            this.syncConfigs();
        }
    }

    public static class Value {
        private String stringValue;
        private int integerValue;
        private boolean booleanValue;
        private ValueType type;

        public Value(String s, ValueType type) {
            this.type = type;
            this.setValue(s);
        }

        public void setValue(String s) {
            this.stringValue = s;
            this.booleanValue = Boolean.parseBoolean(s);
            this.integerValue = this.booleanValue ? 1 : 0;
            try {
                this.integerValue = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public ValueType getType() {
            return this.type;
        }
    }

    public static enum ValueType {
        BOOLEAN,
        INTEGER;

    }
}

