/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.globalgamerules.GGRConfig;

public class WorldEvents {
    public static final Logger LOGGER = LogManager.getLogger((String)"GlobalGameRules");

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().isRemote && event.getEntity() instanceof PlayerEntity) {
            World world = event.getWorld();
            MinecraftServer server = world.getServer();
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (server != null) {
                ((List)GGRConfig.COMMON.defaultCommands.get()).forEach(s -> {
                    String command = s.replaceAll("@p", player.getGameProfile().getName());
                    server.getCommandManager().handleCommand(server.getCommandSource(), command);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().isRemote()) {
            return;
        }
        IWorld world = event.getWorld();
        WorldInfo info = world.getWorldInfo();
        GameRules rules = info.getGameRulesInstance();
        LOGGER.info("Applying config gamerules to dimension {} ({})", (Object)world.getDimension().getType().getId(), (Object)info.getWorldName());
        HashMap arguments = new HashMap();
        GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> arguments.put(ruleKey.getName(), new ParsedArgument(0, 0, configValue.get())));
        CommandContext context = new CommandContext((Object)world.getWorld().getServer().getCommandSource(), null, arguments, null, null, null, null, null, null, false);
        GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> rules.get(ruleKey).updateValue(context, ruleKey.getName()));
        if (!info.isDifficultyLocked() && ((Boolean)GGRConfig.COMMON.setDifficulty.get()).booleanValue()) {
            Difficulty diff = (Difficulty)GGRConfig.COMMON.difficulty.get();
            info.setDifficulty(diff);
            LOGGER.info("Setting difficulty of dimension {} ({}) to {}", (Object)world.getDimension().getType().getId(), (Object)info.getWorldName(), (Object)diff.toString());
        }
        if (!info.isDifficultyLocked()) {
            Boolean hardcore = (Boolean)GGRConfig.COMMON.hardcore.get();
            info.setHardcore(hardcore.booleanValue());
            if (hardcore.booleanValue() && info.getDifficulty() != Difficulty.HARD) {
                info.setDifficulty(Difficulty.HARD);
            }
            if (hardcore.booleanValue()) {
                LOGGER.info("Setting dimension {} ({}) to hardcore", (Object)world.getDimension().getType().getId(), (Object)info.getWorldName());
            }
        }
        if (((Boolean)GGRConfig.COMMON.lockDifficulty.get()).booleanValue()) {
            info.setDifficultyLocked(true);
            LOGGER.info("Locking difficulty of dimension {} ({})", (Object)world.getDimension().getType().getId(), (Object)info.getWorldName());
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(WorldEvent.Unload event) {
        if (event.getWorld().isRemote()) {
            return;
        }
        IWorld world = event.getWorld();
        WorldInfo info = world.getWorldInfo();
        GameRules rules = info.getGameRulesInstance();
        if (((Boolean)GGRConfig.COMMON.saveGameRules.get()).booleanValue()) {
            GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> {
                GameRules.RuleValue val = rules.get(ruleKey);
                if (val instanceof GameRules.BooleanValue) {
                    ((ForgeConfigSpec.BooleanValue)configValue).set((Object)((GameRules.BooleanValue)val).get());
                } else if (val instanceof GameRules.IntegerValue) {
                    ((ForgeConfigSpec.IntValue)configValue).set((Object)((GameRules.IntegerValue)val).get());
                }
            });
        }
        if (((Boolean)GGRConfig.COMMON.setDifficulty.get()).booleanValue() && !event.getWorld().getWorldInfo().isDifficultyLocked()) {
            GGRConfig.COMMON.difficulty.set((Object)info.getDifficulty());
        }
        GGRConfig.commonSpec.save();
    }
}

