package se.gory_moon.globalgamerules;

import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.gory_moon.globalgamerules.config.GGRConfig;
import se.gory_moon.globalgamerules.reference.Reference;

import java.util.Arrays;

@Mod.EventBusSubscriber(modid = Reference.MODID)
public class WorldEvents {

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = world.func_82736_K();

        Reference.logger.info("Applying config gamerules to dimension {} ({})", world.field_73011_w.getDimension(), info.func_76065_j());
        GlobalGR.getConfig().rules.forEach((s, value) -> gRules.func_82764_b(s, value.getStringValue()));

        if (!event.getWorld().field_72995_K && !info.func_176123_z()) {
            int diff = GlobalGR.getConfig().misc.get(GGRConfig.MISC_WORLDDIFFICULTY).getIntegerValue();
            if (diff != -1) {
                info.func_176144_a(EnumDifficulty.func_151523_a(diff));
                Reference.logger.info("Setting difficulty of dimension {} ({}) to {}", world.field_73011_w.getDimension(), info.func_76065_j(),
                        EnumDifficulty.func_151523_a(diff).toString());
            }

            if (GlobalGR.getConfig().misc.get(GGRConfig.MISC_WORLDDIFFICULTYLOCK).getBooleanValue()) {
                info.func_180783_e(true);
                Reference.logger.info("Locking difficulty of dimension {} ({})", world.field_73011_w.getDimension(), info.func_76065_j());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(WorldEvent.Unload event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = event.getWorld().func_82736_K();

        if (GlobalGR.getConfig().misc.get(GGRConfig.MISC_SAVEGAMRULES).getBooleanValue()) {
            Reference.logger.info("Saving gamerules of dimension {} ({}) to config", world.field_73011_w.getDimension(), info.func_76065_j());
            Arrays.stream(gRules.func_82763_b()).forEach(s -> GlobalGR.getConfig().rules.put(s, new GGRConfig.Value(gRules.func_82767_a(s), getType(gRules, s))));


            if (!event.getWorld().field_72995_K && GlobalGR.getConfig().misc.get(GGRConfig.MISC_WORLDDIFFICULTY).getIntegerValue() != -1 && !event.getWorld().func_72912_H().func_176123_z()) {
                GGRConfig.Value val = GlobalGR.getConfig().misc.get(GGRConfig.MISC_WORLDDIFFICULTY);
                GGRConfig.Value newVal = new GGRConfig.Value(String.valueOf(info.func_176130_y().func_151525_a()), val.getType(), val.getShowInGui());
                GlobalGR.getConfig().misc.put(GGRConfig.MISC_WORLDDIFFICULTY, newVal);
            }
        }

        if (!GlobalGR.getConfig().misc.get(GGRConfig.MISC_SAVEGAMRULES).getBooleanValue()) {
            Arrays.stream(gRules.func_82763_b()).filter(s -> !GlobalGR.getConfig().rules.containsKey(s)).forEach(s -> GlobalGR.getConfig().rules.put(s, new GGRConfig.Value(gRules.func_82767_a(s), getType(gRules, s))));
        }

        GlobalGR.getConfig().saveConfig();
    }

    public static GGRConfig.ValueType getType(GameRules rules, String s) {
        if (rules.func_180264_a(s, GameRules.ValueType.BOOLEAN_VALUE))
            return GGRConfig.ValueType.BOOLEAN;
        else if (rules.func_180264_a(s, GameRules.ValueType.NUMERICAL_VALUE))
            return GGRConfig.ValueType.INTEGER;
        else
            return GGRConfig.ValueType.STRING;
    }
}
