/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import se.gory_moon.globalgamerules.GlobalGR;

public class GGRConfigGUI
extends GuiConfig {
    public GGRConfigGUI(GuiScreen parentScreen) {
        super(parentScreen, GGRConfigGUI.getConfigElements(), "GlobalGameRules", true, false, GuiConfig.getAbridgedConfigPath((String)GlobalGR.getConfig().toString()));
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("gamerules", "ggr.configgui.rules", new ConfigElement(GlobalGR.getConfig().getCategory("gamerules")).getChildElements(), GuiConfigEntries.CategoryEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("misc", "ggr.configgui.misc", new ConfigElement(GlobalGR.getConfig().getCategory("misc")).getChildElements(), GuiConfigEntries.CategoryEntry.class));
        return list;
    }

    public static class DifficultyEntry
    extends GuiConfigEntries.SelectValueEntry {
        public DifficultyEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop, DifficultyEntry.getSelectableValues());
        }

        private static Map<Object, String> getSelectableValues() {
            HashMap<Object, String> selectableValues = new HashMap<Object, String>();
            selectableValues.put(-1, I18n.format((String)"ggr.configgui.diffDisabled", (Object[])new Object[0]));
            for (EnumDifficulty ed : EnumDifficulty.values()) {
                selectableValues.put(ed.getDifficultyId(), I18n.format((String)ed.getDifficultyResourceKey(), (Object[])new Object[0]));
            }
            return selectableValues;
        }

        public void updateValueButtonText() {
            int val = Integer.parseInt(String.valueOf(this.currentValue));
            this.btnValue.displayString = val > -1 ? I18n.format((String)EnumDifficulty.getDifficultyEnum((int)val).getDifficultyResourceKey(), (Object[])new Object[0]) : I18n.format((String)"ggr.configgui.diffDisabled", (Object[])new Object[0]);
        }
    }
}

