/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import se.gory_moon.chargers.blocks.BlockCharger;
import se.gory_moon.chargers.power.CustomEnergyStorage;
import se.gory_moon.chargers.tile.CustomItemStackHandler;
import se.gory_moon.chargers.tile.TileEntityEnergyHolder;

public class TileEntityCharger
extends TileEntityEnergyHolder {
    public final ItemStackHandler inventoryHandler = new CustomItemStackHandler(2);
    private BlockCharger.Tier tier;

    public TileEntityCharger(BlockCharger.Tier tier) {
        this();
        this.setTier(tier);
    }

    public TileEntityCharger() {
    }

    private void setTier(BlockCharger.Tier tier) {
        this.tier = tier;
        this.storage = new CustomEnergyStorage(tier.getStorage(), tier.getMaxIn(), tier.getMaxOut());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.func_177230_c().func_149667_c(newSate.func_177230_c());
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            IEnergyStorage energyStorage;
            ItemStack input = this.inventoryHandler.getStackInSlot(0);
            ItemStack output = this.inventoryHandler.getStackInSlot(1);
            if (!input.func_190926_b() && output.func_190926_b() && this.storage.getEnergyStored() > 0 && input.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)input.getCapability(CapabilityEnergy.ENERGY, null)) != null && input.func_190916_E() == 1) {
                int transferred = energyStorage.receiveEnergy(this.storage.extractEnergy(this.storage.getEnergyStored(), true), false);
                if (transferred > 0) {
                    this.storage.extractEnergy(transferred, false);
                }
                if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
                    this.inventoryHandler.setStackInSlot(1, input.func_77946_l());
                    input.func_190918_g(1);
                    this.inventoryHandler.setStackInSlot(0, input.func_190916_E() <= 0 ? ItemStack.field_190927_a : input);
                }
            }
            super.func_73660_a();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventoryHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.setTier(BlockCharger.Tier.byMetadata(compound.func_74762_e("Tier")));
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventoryHandler.serializeNBT());
        compound.func_74768_a("Tier", this.tier.getMeta());
        return compound;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryHandler;
        }
        return super.getCapability(capability, facing);
    }
}

