/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.blocks.BlockEnergy;
import se.gory_moon.chargers.blocks.BlockRegistry;
import se.gory_moon.chargers.items.ItemChargerBlock;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class BlockCharger
extends BlockEnergy
implements BlockRegistry.ISubtypeItemBlockModelDefinition,
BlockRegistry.ICustomItemBlock {
    public static PropertyEnum<Tier> TIERS = PropertyEnum.func_177709_a((String)"tier", Tier.class);

    public BlockCharger() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((Tier)((Object)state.func_177229_b(TIERS))).getColor();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCharger) {
            if (player.func_70093_af()) {
                return false;
            }
            player.openGui((Object)ChargersMod.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity aTile;
        if (!world.field_72995_K && (aTile = world.func_175625_s(pos)) instanceof TileEntityCharger) {
            TileEntityCharger tile = (TileEntityCharger)aTile;
            for (int i = 0; i < tile.inventoryHandler.getSlots(); ++i) {
                ItemStack stack = tile.inventoryHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                BlockCharger.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149732_F() {
        return I18n.func_135052_a((String)(this.func_149739_a() + "." + Tier.I.func_176610_l() + ".name"), (Object[])new Object[0]);
    }

    @Override
    @Nonnull
    public ItemBlock getItemBlock() {
        return new ItemChargerBlock(this, this, stack -> Tier.byMetadata(stack.func_77960_j()).func_176610_l());
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Tier tier : Tier.values()) {
            items.add((Object)new ItemStack((Block)this, 1, tier.getMeta()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((Tier)((Object)state.func_177229_b(TIERS))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TIERS, (Comparable)((Object)Tier.byMetadata(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIERS});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCharger((Tier)((Object)state.func_177229_b(TIERS)));
    }

    @Override
    public int getSubtypeNumber() {
        return 3;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + Tier.byMetadata(meta).func_176610_l();
    }

    public static enum Tier implements IStringSerializable
    {
        I("tier_1", 0, MapColor.field_151670_w),
        II("tier_2", 1, MapColor.field_151647_F),
        III("tier_3", 2, MapColor.field_151679_y);

        private String unloc;
        private int meta;
        private MapColor color;
        private static final Tier[] META_LOOKUP;

        private Tier(String unloc, int meta, MapColor color) {
            this.unloc = unloc;
            this.meta = meta;
            this.color = color;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getColor() {
            return this.color;
        }

        public String func_176610_l() {
            return this.unloc;
        }

        public int getStorage() {
            return this == I ? Configs.chargers.tier1.storage : (this == II ? Configs.chargers.tier2.storage : Configs.chargers.tier3.storage);
        }

        public int getMaxIn() {
            return this == I ? Configs.chargers.tier1.maxInput : (this == II ? Configs.chargers.tier2.maxInput : Configs.chargers.tier3.maxInput);
        }

        public int getMaxOut() {
            return this == I ? Configs.chargers.tier1.maxOutput : (this == II ? Configs.chargers.tier2.maxOutput : Configs.chargers.tier3.maxOutput);
        }

        public static Tier byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Tier[Tier.values().length];
            Tier[] tierArray = Tier.values();
            int n = tierArray.length;
            for (int i = 0; i < n; ++i) {
                Tier tier;
                Tier.META_LOOKUP[tier.getMeta()] = tier = tierArray[i];
            }
        }
    }
}

