package se.gory_moon.chargers.client;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.inventory.ContainerCharger;
import se.gory_moon.chargers.lib.ModInfo;
import se.gory_moon.chargers.tile.TileEntityCharger;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class GuiCharger extends GuiContainer {

    private TileEntityCharger charger;
    private static final ResourceLocation CHARGER_GUI_TEXTURE = new ResourceLocation(ModInfo.MODID + ":textures/gui/charger.png");
    private static final ResourceLocation CHARGER_BAUBLES_GUI_TEXTURE = new ResourceLocation(ModInfo.MODID + ":textures/gui/charger_baubles.png");
    public static final ResourceLocation BAUBLES = new ResourceLocation("baubles","textures/gui/expanded_inventory.png");
    public GuiCharger(EntityPlayer player, TileEntityCharger tile) {
        super(new ContainerCharger(player, tile));
        this.charger = tile;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        boolean baubles = Baubles.isLoaded();
        if (baubles) {
            field_146297_k.field_71446_o.func_110577_a(CHARGER_BAUBLES_GUI_TEXTURE);
        } else {
            field_146297_k.field_71446_o.func_110577_a(CHARGER_GUI_TEXTURE);
        }
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        if (charger.storage.getEnergyStored() > 0) {
            double progress = ((double)charger.storage.getEnergyStored() / (double) charger.storage.getMaxEnergyStored() * 70);
            drawTexturedModalRect(field_147003_i + 48 - (baubles ? 9: 0), field_147009_r + 78 - progress, 0, 236 - progress, 16, progress);
        }

        if (baubles) {
            field_146297_k.field_71446_o.func_110577_a(BAUBLES);
            IItemHandler handler = ((ContainerCharger)field_147002_h).baubles;
            for (int i = 0; i < 7; i++) {
                if (handler.getStackInSlot(i).func_190926_b()) {
                    int texX = 77 + (i / 4) * 19;
                    int texY = 8 + (i % 4) * 18;
                    func_73729_b(field_147003_i + 103 + (i / 4) * 18, field_147009_r + 8 + (i % 4) * 18, texX, texY, 16, 16);
                }
            }
        }
    }

    private void drawTexturedModalRect(double x, double y, double textureX, double textureY, double width, double height)
    {
        double f = 0.00390625D;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, (double)this.field_73735_i)           .func_187315_a(textureX * f, (textureY + height) * f)             .func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, (double)this.field_73735_i)   .func_187315_a((textureX + width) * f, (textureY + height) * f)   .func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, (double)this.field_73735_i)            .func_187315_a((textureX + width) * f, textureY * f)              .func_181675_d();
        bufferbuilder.func_181662_b(x, y, (double)this.field_73735_i)                    .func_187315_a(textureX * f, textureY * f)                        .func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        func_191948_b(mouseX, mouseY);
        boolean baubles = Baubles.isLoaded();

        if (mouseX >= field_147003_i + 48 - (baubles ? 9: 0) && mouseX <= field_147003_i + 48 + 16 - (baubles ? 9: 0) && mouseY >= field_147009_r + 8 && mouseY <= field_147009_r + 78) {
            NumberFormat format = NumberFormat.getInstance();
            List<String> list = new ArrayList<>();
            list.add(I18n.func_135052_a("gui.chargers.energy", format.format(charger.storage.getEnergyStored()), format.format(charger.storage.getMaxEnergyStored()) + TextFormatting.GRAY));
            list.add(I18n.func_135052_a("gui.chargers.max_in", format.format(charger.storage.getMaxInput()) + TextFormatting.GRAY));
            list.add(I18n.func_135052_a("gui.chargers.max_out", format.format(charger.storage.getMaxOutput()) + TextFormatting.GRAY));
            if (charger.getEnergyDiff() != 0) {
                list.add(I18n.func_135052_a("gui.chargers.io", (charger.getEnergyDiff() > 0 ? TextFormatting.GREEN + "+": TextFormatting.RED.toString()) + Math.round(charger.getEnergyDiff()) + TextFormatting.GRAY));
            }
            func_146283_a(list, mouseX, mouseY);
        }
    }
}
