package se.gory_moon.chargers.blocks;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.chargers.blocks.BlockRegistry.ICustomItemBlock;
import se.gory_moon.chargers.items.ItemWirelessChargerBlock;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.text.NumberFormat;
import java.util.List;

public class BlockWirelessCharger extends BlockEnergy implements ICustomItemBlock {

    public static PropertyBool POWERED = PropertyBool.func_177716_a("powered");

    public BlockWirelessCharger() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        func_149711_c(5);
        func_149752_b(10);
        func_149647_a(CreativeTabs.field_78028_d);
        setHarvestLevel("pickaxe", 0);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            return state.func_177226_a(POWERED, ((TileEntityWirelessCharger) tileEntity).canCharge());
        }
        return state;
    }

    @Nonnull
    @Override
    public ItemBlock getItemBlock() {
        return new ItemWirelessChargerBlock(this);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K)
            return true;

        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            if (player.func_70093_af())
                return false;
            TileEntityWirelessCharger tile = (TileEntityWirelessCharger) tileEntity;
            boolean powered = ((TileEntityWirelessCharger) tileEntity).isPowered();
            ITextComponent status = new TextComponentTranslation("chat.chargers." + (powered ? "disabled": "enabled")).func_150255_a(new Style().func_150238_a(powered ? TextFormatting.RED: TextFormatting.GREEN));
            NumberFormat format = NumberFormat.getInstance();
            player.func_146105_b(new TextComponentTranslation("chat.chargers.wireless_charger.info",  status, format.format(tile.storage.getEnergyStored()), format.format(tile.storage.getMaxEnergyStored())), true);
        }

        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, POWERED);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(POWERED, false);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a("tooltip.chargers.wireless_charger"));
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityWirelessCharger();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }
}
