/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import se.gory_moon.chargers.tile.TileEntityCharger;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

public class TileRegistry {
    private TileRegistry() {
    }

    public static void init() {
        TileRegistry.registerTileEntity(TileEntityCharger.class, "charger");
        TileRegistry.registerTileEntity(TileEntityWirelessCharger.class, "wireless_charger");
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("chargers", 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityFixer());
    }

    private static void registerTileEntity(Class<? extends TileEntity> cls, String baseName) {
        GameRegistry.registerTileEntity(cls, (ResourceLocation)new ResourceLocation("chargers", baseName));
    }

    private static class TileEntityFixer
    implements IFixableData {
        private TileEntityFixer() {
        }

        public int getFixVersion() {
            return 1;
        }

        private boolean needReplacing(String id) {
            return "tile.fastcharge.charger".equals(id) || "tile.fastcharge.wireless_charger".equals(id);
        }

        private String getId(String id) {
            return id.replaceAll("tile.fastcharge.", "");
        }

        public NBTTagCompound fixTagCompound(NBTTagCompound compound) {
            String id = compound.getString("id");
            if (this.needReplacing(id)) {
                compound.setString("id", "chargers:" + this.getId(id));
            }
            return compound;
        }
    }
}

