/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.power;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    private AverageCalculator in = new AverageCalculator();
    private AverageCalculator out = new AverageCalculator();
    private int energyIn;
    private int energyOut;
    private float averageIn;
    private float averageOut;

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public int getMaxInput() {
        return this.maxReceive;
    }

    public int getMaxOutput() {
        return this.maxExtract;
    }

    public float getAverageChange() {
        return this.averageIn - this.averageOut;
    }

    public void tick() {
        this.in.tick(this.energyIn);
        this.out.tick(this.energyOut);
        this.averageIn = this.in.getAverage();
        this.averageOut = this.out.getAverage();
        this.energyIn = 0;
        this.energyOut = 0;
    }

    private void setEnergy(int energy) {
        if (energy > 0) {
            this.energyIn += energy;
        } else {
            this.energyOut -= energy;
        }
        this.setEnergyInternal(energy);
    }

    protected void setEnergyInternal(int energy) {
        this.energy += energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.getEnergyStored(), Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            this.setEnergy(energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxOutput(), maxExtract));
        if (!simulate) {
            this.setEnergy(-energyExtracted);
        }
        return energyExtracted;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.energy = compound.getInteger("Energy");
        this.averageIn = compound.getFloat("In");
        this.averageOut = compound.getFloat("Out");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("Energy", this.getEnergyStored());
        compound.setFloat("In", this.in.getAverage());
        compound.setFloat("Out", this.out.getAverage());
        return compound;
    }

    private static class AverageCalculator {
        private int lastTotal;
        private int tickCount;
        private float[] cache = new float[2];
        private int writeIndex;
        private int writeSize;

        private AverageCalculator() {
        }

        public float getAverage() {
            int ticks = this.tickCount + this.writeSize * 20;
            if (ticks == 0) {
                return 0.0f;
            }
            float total = this.lastTotal;
            int i = this.writeIndex;
            int c = this.writeSize;
            while (c-- > 0) {
                total += this.cache[i];
                if (++i != this.cache.length) continue;
                i = 0;
            }
            return total / (float)ticks;
        }

        public void tick(long val) {
            this.lastTotal = (int)((long)this.lastTotal + val);
            ++this.tickCount;
            if (this.tickCount == 20) {
                this.cache[this.writeIndex++] = this.lastTotal;
                if (this.writeIndex > this.writeSize) {
                    this.writeSize = this.writeIndex;
                }
                if (this.writeIndex == this.cache.length) {
                    this.writeIndex = 0;
                }
                this.lastTotal = 0;
                this.tickCount = 0;
            }
        }
    }
}

