/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.compat;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.compat.SlotBauble;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

public class Baubles {
    public static Baubles INSTANCE = new Baubles();
    private static final boolean loaded = Loader.isModLoaded((String)"baubles");

    public static boolean isLoaded() {
        return loaded && Configs.compat.baublesCompat;
    }

    public static IItemHandler getBaubles(EntityPlayer player) {
        if (Baubles.isLoaded()) {
            return BaublesApi.getBaublesHandler((EntityPlayer)player);
        }
        return null;
    }

    public static SlotItemHandler getSlot(EntityPlayer player, IItemHandler itemHandler, int slot, int x, int y) {
        if (Baubles.isLoaded()) {
            return new SlotBauble(player, (IBaublesItemHandler)itemHandler, slot, x, y);
        }
        return new SlotItemHandler(itemHandler, slot, x, y){

            public int getSlotStackLimit() {
                return 1;
            }
        };
    }

    public boolean chargeItems(EntityPlayer player, TileEntityWirelessCharger charger) {
        IBaublesItemHandler handler;
        boolean result = false;
        if (Baubles.isLoaded() && (handler = BaublesApi.getBaublesHandler((EntityPlayer)player)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty() || !charger.chargeItems((NonNullList<ItemStack>)NonNullList.from((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{stack = stack.copy()}))) continue;
                handler.setStackInSlot(i, stack);
                result = true;
            }
        }
        return result;
    }
}

