/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.client;

import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.inventory.ContainerCharger;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class GuiCharger
extends GuiContainer {
    private TileEntityCharger charger;
    private static final ResourceLocation CHARGER_GUI_TEXTURE = new ResourceLocation("chargers:textures/gui/charger.png");
    private static final ResourceLocation CHARGER_BAUBLES_GUI_TEXTURE = new ResourceLocation("chargers:textures/gui/charger_baubles.png");
    public static final ResourceLocation BAUBLES = new ResourceLocation("baubles", "textures/gui/expanded_inventory.png");

    public GuiCharger(EntityPlayer player, TileEntityCharger tile) {
        super((Container)new ContainerCharger(player, tile));
        this.charger = tile;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean baubles = Baubles.isLoaded();
        if (baubles) {
            this.mc.renderEngine.bindTexture(CHARGER_BAUBLES_GUI_TEXTURE);
        } else {
            this.mc.renderEngine.bindTexture(CHARGER_GUI_TEXTURE);
        }
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.charger.storage.getEnergyStored() > 0) {
            double progress = (double)this.charger.storage.getEnergyStored() / (double)this.charger.storage.getMaxEnergyStored() * 70.0;
            this.drawTexturedModalRect(this.guiLeft + 48 - (baubles ? 9 : 0), (double)(this.guiTop + 78) - progress, 0.0, 236.0 - progress, 16.0, progress);
        }
        if (baubles) {
            this.mc.renderEngine.bindTexture(BAUBLES);
            IItemHandler handler = ((ContainerCharger)this.inventorySlots).baubles;
            for (int i = 0; i < 7; ++i) {
                if (!handler.getStackInSlot(i).isEmpty()) continue;
                int texX = 77 + i / 4 * 19;
                int texY = 8 + i % 4 * 18;
                this.drawTexturedModalRect(this.guiLeft + 103 + i / 4 * 18, this.guiTop + 8 + i % 4 * 18, texX, texY, 16, 16);
            }
        }
    }

    private void drawTexturedModalRect(double x, double y, double textureX, double textureY, double width, double height) {
        double f = 0.00390625;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(7, DefaultVertexFormats.POSITION_TEX);
        bufferbuilder.pos(x, y + height, (double)this.zLevel).tex(textureX * f, (textureY + height) * f).endVertex();
        bufferbuilder.pos(x + width, y + height, (double)this.zLevel).tex((textureX + width) * f, (textureY + height) * f).endVertex();
        bufferbuilder.pos(x + width, y, (double)this.zLevel).tex((textureX + width) * f, textureY * f).endVertex();
        bufferbuilder.pos(x, y, (double)this.zLevel).tex(textureX * f, textureY * f).endVertex();
        tessellator.draw();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
        boolean baubles = Baubles.isLoaded();
        if (mouseX >= this.guiLeft + 48 - (baubles ? 9 : 0) && mouseX <= this.guiLeft + 48 + 16 - (baubles ? 9 : 0) && mouseY >= this.guiTop + 8 && mouseY <= this.guiTop + 78) {
            NumberFormat format = NumberFormat.getInstance();
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.format((String)"gui.chargers.energy", (Object[])new Object[]{format.format(this.charger.storage.getEnergyStored()), format.format(this.charger.storage.getMaxEnergyStored()) + TextFormatting.GRAY}));
            list.add(I18n.format((String)"gui.chargers.max_in", (Object[])new Object[]{format.format(this.charger.storage.getMaxInput()) + TextFormatting.GRAY}));
            list.add(I18n.format((String)"gui.chargers.max_out", (Object[])new Object[]{format.format(this.charger.storage.getMaxOutput()) + TextFormatting.GRAY}));
            if (this.charger.getEnergyDiff() != 0.0f) {
                list.add(I18n.format((String)"gui.chargers.io", (Object[])new Object[]{(this.charger.getEnergyDiff() > 0.0f ? TextFormatting.GREEN + "+" : TextFormatting.RED.toString()) + Math.round(this.charger.getEnergyDiff()) + TextFormatting.GRAY}));
            }
            this.drawHoveringText(list, mouseX, mouseY);
        }
    }
}

