/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import se.gory_moon.chargers.tile.TileEntityCharger;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

public class TileRegistry {
    private TileRegistry() {
    }

    public static void init() {
        TileRegistry.registerTileEntity(TileEntityCharger.class, "charger");
        TileRegistry.registerTileEntity(TileEntityWirelessCharger.class, "wireless_charger");
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("chargers", 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityFixer());
    }

    private static void registerTileEntity(Class<? extends TileEntity> cls, String baseName) {
        GameRegistry.registerTileEntity(cls, (ResourceLocation)new ResourceLocation("chargers", baseName));
    }

    private static class TileEntityFixer
    implements IFixableData {
        private TileEntityFixer() {
        }

        public int func_188216_a() {
            return 1;
        }

        private boolean needReplacing(String id) {
            return "tile.fastcharge.charger".equals(id) || "tile.fastcharge.wireless_charger".equals(id);
        }

        private String getId(String id) {
            return id.replaceAll("tile.fastcharge.", "");
        }

        public NBTTagCompound func_188217_a(NBTTagCompound compound) {
            String id = compound.func_74779_i("id");
            if (this.needReplacing(id)) {
                compound.func_74778_a("id", "chargers:" + this.getId(id));
            }
            return compound;
        }
    }
}

