/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import se.gory_moon.chargers.blocks.BlockCharger;
import se.gory_moon.chargers.power.CustomEnergyStorage;
import se.gory_moon.chargers.tile.CustomItemStackHandler;
import se.gory_moon.chargers.tile.TileEntityEnergyHolder;

public class TileEntityCharger
extends TileEntityEnergyHolder {
    public final ItemStackHandler inventoryHandler = new CustomItemStackHandler(2);
    private BlockCharger.Tier tier;

    public TileEntityCharger(BlockCharger.Tier tier) {
        this();
        this.setTier(tier);
    }

    public TileEntityCharger() {
    }

    private void setTier(BlockCharger.Tier tier) {
        this.tier = tier;
        this.storage = new CustomEnergyStorage(tier.getStorage(), tier.getMaxIn(), tier.getMaxOut());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.getBlock().isAssociatedBlock(newSate.getBlock());
    }

    @Override
    public void update() {
        if (!this.getWorld().isRemote) {
            IEnergyStorage energyStorage;
            ItemStack input = this.inventoryHandler.getStackInSlot(0);
            ItemStack output = this.inventoryHandler.getStackInSlot(1);
            if (!input.isEmpty() && output.isEmpty() && this.storage.getEnergyStored() > 0 && input.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)input.getCapability(CapabilityEnergy.ENERGY, null)) != null && input.getCount() == 1) {
                int transferred = energyStorage.receiveEnergy(this.storage.extractEnergy(this.storage.getEnergyStored(), true), false);
                if (transferred > 0) {
                    this.storage.extractEnergy(transferred, false);
                }
                if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
                    this.inventoryHandler.setStackInSlot(1, input.copy());
                    input.shrink(1);
                    this.inventoryHandler.setStackInSlot(0, input.getCount() <= 0 ? ItemStack.EMPTY : input);
                }
            }
            super.update();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.inventoryHandler.deserializeNBT(compound.getCompoundTag("Inventory"));
        this.setTier(BlockCharger.Tier.byMetadata(compound.getInteger("Tier")));
        super.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        compound.setTag("Inventory", (NBTBase)this.inventoryHandler.serializeNBT());
        compound.setInteger("Tier", this.tier.getMeta());
        return compound;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryHandler;
        }
        return super.getCapability(capability, facing);
    }
}

