/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.compat;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SlotBauble
extends SlotItemHandler {
    private int baubleSlot;
    private EntityPlayer player;

    public SlotBauble(EntityPlayer player, IBaublesItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super((IItemHandler)itemHandler, index, xPosition, yPosition);
        this.player = player;
        this.baubleSlot = index;
    }

    public boolean isItemValid(ItemStack stack) {
        return ((IBaublesItemHandler)this.getItemHandler()).isItemValidForSlot(this.baubleSlot, stack, (EntityLivingBase)this.player);
    }

    public boolean canTakeStack(EntityPlayer player) {
        ItemStack stack = this.getStack();
        if (stack.isEmpty() && !stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            return false;
        }
        IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
        return bauble.canUnequip(stack, (EntityLivingBase)player);
    }

    public ItemStack onTake(EntityPlayer playerIn, ItemStack stack) {
        if (!this.getHasStack() && stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            ((IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)).onUnequipped(stack, (EntityLivingBase)playerIn);
        }
        super.onTake(playerIn, stack);
        return stack;
    }

    public void putStack(ItemStack stack) {
        if (this.getHasStack() && !ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)this.getStack()) && this.getStack().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            ((IBauble)this.getStack().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)).onUnequipped(this.getStack(), (EntityLivingBase)this.player);
        }
        ItemStack oldStack = this.getStack().copy();
        super.putStack(stack);
        if (this.getHasStack() && !ItemStack.areItemStacksEqual((ItemStack)oldStack, (ItemStack)this.getStack()) && this.getStack().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            ((IBauble)this.getStack().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)).onEquipped(this.getStack(), (EntityLivingBase)this.player);
        }
    }

    public int getSlotStackLimit() {
        return 1;
    }
}

