/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.client;

import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.inventory.ContainerCharger;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class GuiCharger
extends GuiContainer {
    private TileEntityCharger charger;
    private static final ResourceLocation CHARGER_GUI_TEXTURE = new ResourceLocation("chargers:textures/gui/charger.png");
    private static final ResourceLocation CHARGER_BAUBLES_GUI_TEXTURE = new ResourceLocation("chargers:textures/gui/charger_baubles.png");
    public static final ResourceLocation BAUBLES = new ResourceLocation("baubles", "textures/gui/expanded_inventory.png");

    public GuiCharger(EntityPlayer player, TileEntityCharger tile) {
        super((Container)new ContainerCharger(player, tile));
        this.charger = tile;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean baubles = Baubles.isLoaded();
        if (baubles) {
            this.field_146297_k.field_71446_o.func_110577_a(CHARGER_BAUBLES_GUI_TEXTURE);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(CHARGER_GUI_TEXTURE);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.charger.storage.getEnergyStored() > 0) {
            double progress = (double)this.charger.storage.getEnergyStored() / (double)this.charger.storage.getMaxEnergyStored() * 70.0;
            this.drawTexturedModalRect(this.field_147003_i + 48 - (baubles ? 9 : 0), (double)(this.field_147009_r + 78) - progress, 0.0, 236.0 - progress, 16.0, progress);
        }
        if (baubles) {
            this.field_146297_k.field_71446_o.func_110577_a(BAUBLES);
            IItemHandler handler = ((ContainerCharger)this.field_147002_h).baubles;
            for (int i = 0; i < 7; ++i) {
                if (!handler.getStackInSlot(i).func_190926_b()) continue;
                int texX = 77 + i / 4 * 19;
                int texY = 8 + i % 4 * 18;
                this.func_73729_b(this.field_147003_i + 103 + i / 4 * 18, this.field_147009_r + 8 + i % 4 * 18, texX, texY, 16, 16);
            }
        }
    }

    private void drawTexturedModalRect(double x, double y, double textureX, double textureY, double width, double height) {
        double f = 0.00390625;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, (double)this.field_73735_i).func_187315_a(textureX * f, (textureY + height) * f).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, (double)this.field_73735_i).func_187315_a((textureX + width) * f, (textureY + height) * f).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, (double)this.field_73735_i).func_187315_a((textureX + width) * f, textureY * f).func_181675_d();
        bufferbuilder.func_181662_b(x, y, (double)this.field_73735_i).func_187315_a(textureX * f, textureY * f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        boolean baubles = Baubles.isLoaded();
        if (mouseX >= this.field_147003_i + 48 - (baubles ? 9 : 0) && mouseX <= this.field_147003_i + 48 + 16 - (baubles ? 9 : 0) && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 78) {
            NumberFormat format = NumberFormat.getInstance();
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)"gui.chargers.energy", (Object[])new Object[]{format.format(this.charger.storage.getEnergyStored()), format.format(this.charger.storage.getMaxEnergyStored()) + TextFormatting.GRAY}));
            list.add(I18n.func_135052_a((String)"gui.chargers.max_in", (Object[])new Object[]{format.format(this.charger.storage.getMaxInput()) + TextFormatting.GRAY}));
            list.add(I18n.func_135052_a((String)"gui.chargers.max_out", (Object[])new Object[]{format.format(this.charger.storage.getMaxOutput()) + TextFormatting.GRAY}));
            if (this.charger.getEnergyDiff() != 0.0f) {
                list.add(I18n.func_135052_a((String)"gui.chargers.io", (Object[])new Object[]{(this.charger.getEnergyDiff() > 0.0f ? TextFormatting.GREEN + "+" : TextFormatting.RED.toString()) + Math.round(this.charger.getEnergyDiff()) + TextFormatting.GRAY}));
            }
            this.func_146283_a(list, mouseX, mouseY);
        }
    }
}

