package se.gory_moon.chargers.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.network.MessageUpdatePower;
import se.gory_moon.chargers.network.PacketHandler;

import javax.annotation.Nullable;

public class TileEntityWirelessCharger extends TileEntity implements ITickable {

    public CustomEnergyStorage storage;
    private boolean registered = false;
    private int lastPowered = -1;
    private int availableEnergy;

    public TileEntityWirelessCharger() {
        storage = new CustomEnergyStorage(Configs.chargers.wireless.wirelessStorage, Configs.chargers.wireless.wirelessMaxInput, Configs.chargers.wireless.wirelessMaxOutput);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        WirelessHandler.INSTANCE.unRegister(this);
        registered = false;
    }

    @Override
    public void func_70296_d() {
        final IBlockState state = func_145831_w().func_180495_p(func_174877_v());
        func_145831_w().func_184138_a(func_174877_v(), state, state, 2);
        super.func_70296_d();
    }

    @Override
    public void func_73660_a() {
        if (field_145850_b.field_72995_K && !registered) {
            WirelessHandler.INSTANCE.register(this);
            registered = true;
        }
        if (lastPowered == -1 || (lastPowered == 0 && storage.getEnergyStored() > 0) || (lastPowered > 0 && storage.getEnergyStored() == 0)) {
           if (field_145850_b.field_72995_K) {
               PacketHandler.INSTANCE.sendToAllAround(new MessageUpdatePower(this), this);
           }
            lastPowered = storage.getEnergyStored();
            func_70296_d();
        }
    }

    public void updateAvailable() {
        availableEnergy = Math.min(storage.getMaxOutput(), storage.getEnergyStored());
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean charged = false;
        for (int i = 0; i < items.size() && availableEnergy > 0; i++) {
            ItemStack stack = items.get(i);
            if (!stack.func_190926_b() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage energyStorage = stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (energyStorage != null && stack.func_190916_E() == 1) {
                    int transferred = energyStorage.receiveEnergy(availableEnergy, false);
                    if (transferred > 0) {
                        storage.extractEnergy(transferred, false);
                        availableEnergy -= transferred;
                        charged = true;
                    }
                }
            }
        }
        return charged;
    }

    public boolean canCharge() {
        return storage.getEnergyStored() > 0 && !isPowered();
    }

    public boolean isPowered() {
        return field_145850_b.func_175667_e(func_174877_v()) && field_145850_b.func_175687_A(func_174877_v()) > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        storage.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return storage.writeToNBT(super.func_189515_b(compound));
    }

    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        func_145839_a(tag);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @SuppressWarnings("unchecked")
    @Nullable
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY)
            return (T) storage;
        else
            return super.getCapability(capability, facing);
    }
}
