/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.network.MessageUpdatePower;
import se.gory_moon.chargers.network.PacketHandler;
import se.gory_moon.chargers.tile.CustomEnergyStorage;

public class TileEntityWirelessCharger
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage;
    private boolean registered = false;
    private int lastPowered = -1;
    private int availableEnergy;

    public TileEntityWirelessCharger() {
        this.storage = new CustomEnergyStorage(Configs.chargers.wireless.wirelessStorage, Configs.chargers.wireless.wirelessMaxInput, Configs.chargers.wireless.wirelessMaxOutput);
    }

    public void invalidate() {
        super.invalidate();
        WirelessHandler.INSTANCE.unRegister(this);
        this.registered = false;
    }

    public void markDirty() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 2);
        super.markDirty();
    }

    public void update() {
        if (this.world.isRemote && !this.registered) {
            WirelessHandler.INSTANCE.register(this);
            this.registered = true;
        }
        if (this.lastPowered == -1 || this.lastPowered == 0 && this.storage.getEnergyStored() > 0 || this.lastPowered > 0 && this.storage.getEnergyStored() == 0) {
            if (this.world.isRemote) {
                PacketHandler.INSTANCE.sendToAllAround(new MessageUpdatePower(this), this);
            }
            this.lastPowered = this.storage.getEnergyStored();
            this.markDirty();
        }
    }

    public void updateAvailable() {
        this.availableEnergy = Math.min(this.storage.getMaxOutput(), this.storage.getEnergyStored());
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean charged = false;
        for (int i = 0; i < items.size() && this.availableEnergy > 0; ++i) {
            int transferred;
            IEnergyStorage energyStorage;
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty() || !stack.hasCapability(CapabilityEnergy.ENERGY, null) || (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) == null || stack.getCount() != 1 || (transferred = energyStorage.receiveEnergy(this.availableEnergy, false)) <= 0) continue;
            this.storage.extractEnergy(transferred, false);
            this.availableEnergy -= transferred;
            charged = true;
        }
        return charged;
    }

    public boolean canCharge() {
        return this.storage.getEnergyStored() > 0 && !this.isPowered();
    }

    public boolean isPowered() {
        return this.world.isBlockLoaded(this.getPos()) && this.world.getRedstonePowerFromNeighbors(this.getPos()) > 0;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        return this.storage.writeToNBT(super.writeToNBT(compound));
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, -1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.getNbtCompound());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

