/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.blocks.BlockCharger;
import se.gory_moon.chargers.tile.CustomEnergyStorage;
import se.gory_moon.chargers.tile.CustomItemStackHandler;

public class TileEntityCharger
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage;
    public final ItemStackHandler inventoryHandler = new CustomItemStackHandler(2);
    public BlockCharger.Tier tier;

    public TileEntityCharger(BlockCharger.Tier tier) {
        this();
        this.setTier(tier);
    }

    public TileEntityCharger() {
    }

    private void setTier(BlockCharger.Tier tier) {
        int maxIn;
        int storageAmount;
        this.tier = tier;
        int n = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.storage : (storageAmount = tier == BlockCharger.Tier.II ? Configs.chargers.tier2.storage : Configs.chargers.tier3.storage);
        int n2 = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxInput : (maxIn = tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxInput : Configs.chargers.tier3.maxInput);
        int maxOut = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxOutput : (tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxOutput : Configs.chargers.tier3.maxOutput);
        this.storage = new CustomEnergyStorage(storageAmount, maxIn, maxOut);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.getBlock().isAssociatedBlock(newSate.getBlock());
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            IEnergyStorage energyStorage;
            ItemStack input = this.inventoryHandler.getStackInSlot(0);
            ItemStack output = this.inventoryHandler.getStackInSlot(1);
            if (!input.isEmpty() && output.isEmpty() && this.storage.getEnergyStored() > 0 && input.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)input.getCapability(CapabilityEnergy.ENERGY, null)) != null && input.getCount() == 1) {
                int transferred = energyStorage.receiveEnergy(this.storage.extractEnergy(this.storage.getEnergyStored(), true), false);
                if (transferred > 0) {
                    this.storage.extractEnergy(transferred, false);
                }
                if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
                    this.inventoryHandler.setStackInSlot(1, input.copy());
                    input.shrink(1);
                    this.inventoryHandler.setStackInSlot(0, input.getCount() <= 0 ? ItemStack.EMPTY : input);
                }
            }
            this.storage.tick();
        }
    }

    public float getEnergyDiff() {
        return this.storage.getAverageChange();
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.inventoryHandler.deserializeNBT(compound.getCompoundTag("Inventory"));
        this.setTier(BlockCharger.Tier.byMetadata(compound.getInteger("Tier")));
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        compound.setTag("Inventory", (NBTBase)this.inventoryHandler.serializeNBT());
        compound.setInteger("Tier", this.tier.getMeta());
        compound = this.storage.writeToNBT(compound);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, -1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.getNbtCompound());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

