/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.network;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.network.MessageUpdatePower;

public class PacketHandler {
    public static final PacketHandler INSTANCE = new PacketHandler();
    private SimpleNetworkWrapper networkWrapper;

    public void preInit() {
        this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("chargers");
        this.networkWrapper.registerMessage((IMessageHandler)new ClientboundHandler(), MessageUpdatePower.class, 0, Side.CLIENT);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.networkWrapper.sendTo(message, player);
    }

    public void sendToAllAround(IMessage packet, BlockPos pos, World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerChunkMap playerManager = worldServer.getPlayerChunkMap();
        int chunkX = pos.getX() >> 4;
        int chunkZ = pos.getZ() >> 4;
        for (Object playerObj : world.playerEntities) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.isPlayerWatchingChunk(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            this.sendTo(packet, player);
        }
    }

    public void sendToAllAround(IMessage message, TileEntity te) {
        this.sendToAllAround(message, te.getPos(), te.getWorld());
    }

    private static class ClientboundHandler
    implements IMessageHandler<MessageUpdatePower, IMessage> {
        private ClientboundHandler() {
        }

        public IMessage onMessage(MessageUpdatePower message, MessageContext ctx) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            try {
                if (mc.isCallingFromMinecraftThread()) {
                    message.handle(ctx);
                } else {
                    mc.addScheduledTask(() -> message.handle(ctx));
                }
            }
            catch (Exception e) {
                ChargersMod.LOG.throwing((Throwable)e);
            }
            return null;
        }
    }
}

