/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.blocks.BlockCharger;
import se.gory_moon.chargers.tile.CustomEnergyStorage;
import se.gory_moon.chargers.tile.CustomItemStackHandler;

public class TileEntityCharger
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage;
    public final ItemStackHandler inventoryHandler = new CustomItemStackHandler(2);
    public BlockCharger.Tier tier;
    private int lastEnergy;
    private int diff;

    public TileEntityCharger(BlockCharger.Tier tier) {
        this();
        this.setTier(tier);
    }

    public TileEntityCharger() {
    }

    private void setTier(BlockCharger.Tier tier) {
        int maxIn;
        int storageAmount;
        this.tier = tier;
        int n = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.storage : (storageAmount = tier == BlockCharger.Tier.II ? Configs.chargers.tier2.storage : Configs.chargers.tier3.storage);
        int n2 = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxInput : (maxIn = tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxInput : Configs.chargers.tier3.maxInput);
        int maxOut = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxOutput : (tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxOutput : Configs.chargers.tier3.maxOutput);
        this.storage = new CustomEnergyStorage(storageAmount, maxIn, maxOut);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.func_177230_c().func_149667_c(newSate.func_177230_c());
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            IEnergyStorage energyStorage;
            ItemStack input = this.inventoryHandler.getStackInSlot(0);
            ItemStack output = this.inventoryHandler.getStackInSlot(1);
            if (!input.func_190926_b() && output.func_190926_b() && this.storage.getEnergyStored() > 0 && input.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)input.getCapability(CapabilityEnergy.ENERGY, null)) != null && input.func_190916_E() == 1) {
                int transferred = energyStorage.receiveEnergy(this.storage.extractEnergy(this.storage.getEnergyStored(), true), false);
                if (transferred > 0) {
                    this.storage.extractEnergy(transferred, false);
                }
                if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
                    this.inventoryHandler.setStackInSlot(1, input.func_77946_l());
                    input.func_190918_g(1);
                    this.inventoryHandler.setStackInSlot(0, input.func_190916_E() <= 0 ? ItemStack.field_190927_a : input);
                }
            }
            this.setEnergyDiff(this.storage.getEnergyStored() - this.lastEnergy);
            if (this.lastEnergy != this.storage.getEnergyStored()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public void setEnergyDiff(int diff) {
        this.diff = diff;
    }

    public int getEnergyDiff() {
        return this.diff;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventoryHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.setTier(BlockCharger.Tier.byMetadata(compound.func_74762_e("Tier")));
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventoryHandler.serializeNBT());
        compound.func_74768_a("Tier", this.tier.getMeta());
        compound = this.storage.writeToNBT(compound);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

