/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.inventory;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.chargers.inventory.SlotInput;
import se.gory_moon.chargers.inventory.SlotOutput;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class ContainerCharger
extends Container {
    private static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private TileEntityCharger tileCharger;
    private int lastCharge;
    private int lastDiff;

    public ContainerCharger(InventoryPlayer inventory, TileEntityCharger tile) {
        int i;
        this.tileCharger = tile;
        this.addSlotToContainer((Slot)new SlotInput((IItemHandler)tile.inventoryHandler, 0, 80, 29));
        this.addSlotToContainer((Slot)new SlotOutput((IItemHandler)tile.inventoryHandler, 1, 80, 62));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventory, i, 8 + i * 18, 142));
        }
        final EntityPlayer player = inventory.player;
        for (i = 0; i < 4; ++i) {
            final EntityEquipmentSlot slot = EQUIPMENT_SLOTS[i];
            this.addSlotToContainer(new Slot((IInventory)inventory, 36 + (3 - i), 102, 8 + i * 18){

                public int getSlotStackLimit() {
                    return 1;
                }

                public boolean isItemValid(ItemStack stack) {
                    return !stack.isEmpty() && stack.getItem().isValidArmor(stack, slot, (Entity)player);
                }

                @SideOnly(value=Side.CLIENT)
                public String getSlotTexture() {
                    return ItemArmor.EMPTY_SLOT_NAMES[slot.getIndex()];
                }
            });
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendWindowProperty((Container)this, 0, this.tileCharger.storage.getEnergyStored());
        listener.sendWindowProperty((Container)this, 1, this.tileCharger.getEnergyDiff());
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener listener : this.listeners) {
            if (this.lastCharge != this.tileCharger.storage.getEnergyStored()) {
                listener.sendWindowProperty((Container)this, 0, this.tileCharger.storage.getEnergyStored());
            }
            if (this.lastDiff == this.tileCharger.getEnergyDiff()) continue;
            listener.sendWindowProperty((Container)this, 1, this.tileCharger.getEnergyDiff());
        }
        this.lastCharge = this.tileCharger.storage.getEnergyStored();
        this.lastDiff = this.tileCharger.getEnergyDiff();
    }

    public void updateProgressBar(int id, int data) {
        if (id == 0) {
            this.tileCharger.storage.setEnergy(data);
        } else if (id == 1) {
            this.tileCharger.setEnergyDiff(data);
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        int inventoryStart = 2;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        int armorStart = hotbarEnd + 1;
        int armorEnd = armorStart + 3;
        if (slot != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            itemstack = stack.copy();
            if (index == 1 || index == 0) {
                if (!this.mergeItemStack(stack, inventoryStart, armorEnd + 1, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(stack, itemstack);
            } else if (!stack.hasCapability(CapabilityEnergy.ENERGY, null) ? (index <= inventoryEnd ? !this.mergeItemStack(stack, hotbarStart, hotbarEnd + 1, false) : index >= inventoryEnd + 1 && index < hotbarEnd + 1 && !this.mergeItemStack(stack, inventoryStart, inventoryEnd + 1, false)) : !this.mergeItemStack(stack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemstack;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return player.getDistanceSq((double)this.tileCharger.getPos().getX() + 0.5, (double)this.tileCharger.getPos().getY() + 0.5, (double)this.tileCharger.getPos().getZ() + 0.5) <= 64.0;
    }
}

