/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.client;

import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.chargers.inventory.ContainerCharger;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class GuiCharger
extends GuiContainer {
    private TileEntityCharger charger;
    private static final ResourceLocation CHARGER_GUI_TEXTURE = new ResourceLocation("chargers:textures/gui/charger.png");

    public GuiCharger(InventoryPlayer inventory, TileEntityCharger tile) {
        super((Container)new ContainerCharger(inventory, tile));
        this.charger = tile;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(CHARGER_GUI_TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.charger.storage.getEnergyStored() > 0) {
            int progress = (int)((float)this.charger.storage.getEnergyStored() / (float)this.charger.storage.getMaxEnergyStored() * 70.0f);
            this.drawTexturedModalRect(this.guiLeft + 58, this.guiTop + 78 - progress, 0, 236 - progress, 16, progress);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
        if (mouseX >= this.guiLeft + 58 && mouseX <= this.guiLeft + 74 && mouseY >= this.guiTop + 8 && mouseY <= this.guiTop + 78) {
            NumberFormat format = NumberFormat.getInstance();
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.format((String)"gui.chargers.energy", (Object[])new Object[]{format.format(this.charger.storage.getEnergyStored()), format.format(this.charger.storage.getMaxEnergyStored())}));
            list.add(I18n.format((String)"gui.chargers.max_in", (Object[])new Object[]{format.format(this.charger.storage.getMaxInput())}));
            list.add(I18n.format((String)"gui.chargers.max_out", (Object[])new Object[]{format.format(this.charger.storage.getMaxOutput())}));
            if (this.charger.getEnergyDiff() != 0) {
                list.add(I18n.format((String)"gui.chargers.io", (Object[])new Object[]{(this.charger.getEnergyDiff() > 0 ? TextFormatting.GREEN + "+" : TextFormatting.RED.toString()) + this.charger.getEnergyDiff()}));
            }
            this.drawHoveringText(list, mouseX, mouseY);
        }
    }
}

