/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.blocks.BlockRegistry;
import se.gory_moon.chargers.items.ItemChargerBlock;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class BlockCharger
extends Block
implements BlockRegistry.ISubtypeItemBlockModelDefinition,
BlockRegistry.ICustomItemBlock {
    public static PropertyEnum<Tier> TIERS = PropertyEnum.create((String)"tier", Tier.class);

    public BlockCharger() {
        super(Material.IRON, MapColor.GRAY);
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.setHardness(5.0f);
        this.setResistance(10.0f);
    }

    public MapColor getMapColor(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((Tier)((Object)state.getValue(TIERS))).getColor();
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityCharger) {
            if (player.isSneaking()) {
                return false;
            }
            player.openGui((Object)ChargersMod.INSTANCE, 1, world, pos.getX(), pos.getY(), pos.getZ());
        }
        return true;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity aTile;
        if (!world.isRemote && (aTile = world.getTileEntity(pos)) instanceof TileEntityCharger) {
            TileEntityCharger tile = (TileEntityCharger)aTile;
            for (int i = 0; i < tile.inventoryHandler.getSlots(); ++i) {
                ItemStack stack = tile.inventoryHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                InventoryHelper.spawnItemStack((World)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        super.breakBlock(world, pos, state);
    }

    public String getLocalizedName() {
        return I18n.format((String)(this.getUnlocalizedName() + "." + Tier.I.getName() + ".name"), (Object[])new Object[0]);
    }

    @Override
    @Nonnull
    public ItemBlock getItemBlock() {
        return new ItemChargerBlock(this, this, stack -> Tier.byMetadata(stack.getMetadata()).getName());
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Tier tier : Tier.values()) {
            items.add((Object)new ItemStack((Block)this, 1, tier.getMeta()));
        }
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public int getMetaFromState(IBlockState state) {
        return ((Tier)((Object)state.getValue(TIERS))).getMeta();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TIERS, (Comparable)((Object)Tier.byMetadata(meta)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIERS});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCharger((Tier)((Object)state.getValue(TIERS)));
    }

    @Override
    public int getSubtypeNumber() {
        return 3;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + Tier.byMetadata(meta).getName();
    }

    public static enum Tier implements IStringSerializable
    {
        I("tier_1", 0, MapColor.GRAY),
        II("tier_2", 1, MapColor.GOLD),
        III("tier_3", 2, MapColor.CYAN);

        private String unloc;
        private int meta;
        private MapColor color;
        private static final Tier[] META_LOOKUP;

        private Tier(String unloc, int meta, MapColor color) {
            this.unloc = unloc;
            this.meta = meta;
            this.color = color;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getColor() {
            return this.color;
        }

        public String getName() {
            return this.unloc;
        }

        public static Tier byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Tier[Tier.values().length];
            Tier[] tierArray = Tier.values();
            int n = tierArray.length;
            for (int i = 0; i < n; ++i) {
                Tier tier;
                Tier.META_LOOKUP[tier.getMeta()] = tier = tierArray[i];
            }
        }
    }
}

